/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.framework.container.S2Container;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.MethodNotFoundRuntimeException;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.scope.Scope;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.scope.ScopeMetaData;
import org.seasar.ymir.scope.annotation.In;
import org.seasar.ymir.scope.annotation.Out;
import org.seasar.ymir.scope.annotation.Populate;
import org.seasar.ymir.scope.handler.ScopeAttributeInjector;
import org.seasar.ymir.scope.handler.ScopeAttributeOutjector;
import org.seasar.ymir.scope.handler.ScopeAttributePopulator;
import org.seasar.ymir.scope.handler.ScopeAttributeResolver;
import org.seasar.ymir.scope.handler.impl.ScopeAttributeInjectorImpl;
import org.seasar.ymir.scope.handler.impl.ScopeAttributeOutjectorImpl;
import org.seasar.ymir.scope.handler.impl.ScopeAttributePopulatorImpl;
import org.seasar.ymir.scope.handler.impl.ScopeAttributeResolverImpl;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeMetaDataImpl
implements ScopeMetaData {
    private static final String SUFFIX_SCOPE = "Scope";
    private Class<?> class_;
    private S2Container container_;
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ApplicationManager applicationManager_;
    private ScopeManager scopeManager_;
    private TypeConversionManager typeConversionManager_;
    private List<ScopeAttributeInjector> scopeAttributeInjectorList_ = new ArrayList<ScopeAttributeInjector>();
    private List<ScopeAttributeOutjector> scopeAttributeOutjectorList_ = new ArrayList<ScopeAttributeOutjector>();
    private Map<Scope, ScopeAttributePopulatorImpl> scopeAttributePopulatorMap_ = new HashMap<Scope, ScopeAttributePopulatorImpl>();
    private Map<Method, ScopeAttributeResolver[]> scopeAttributeResolversMap_ = new HashMap<Method, ScopeAttributeResolver[]>();

    public ScopeMetaDataImpl(Class<?> clazz, S2Container container, ActionManager actionManager, AnnotationHandler annotationHandler, ApplicationManager applicationManager, ScopeManager scopeManager, TypeConversionManager typeConversionManager) {
        this.class_ = clazz;
        this.container_ = container;
        this.actionManager_ = actionManager;
        this.annotationHandler_ = annotationHandler;
        this.applicationManager_ = applicationManager;
        this.scopeManager_ = scopeManager;
        this.typeConversionManager_ = typeConversionManager;
        Method[] methods = ClassUtils.getMethods(clazz);
        for (int i = 0; i < methods.length; ++i) {
            this.register(methods[i]);
        }
    }

    @Override
    public ScopeAttributePopulator[] getScopeAttributePopulators() {
        return this.scopeAttributePopulatorMap_.values().toArray(new ScopeAttributePopulator[0]);
    }

    @Override
    public ScopeAttributeInjector[] getScopeAttributeInjectors() {
        return this.scopeAttributeInjectorList_.toArray(new ScopeAttributeInjector[0]);
    }

    @Override
    public ScopeAttributeOutjector[] getScopeAttributeOutjectors() {
        return this.scopeAttributeOutjectorList_.toArray(new ScopeAttributeOutjector[0]);
    }

    /*
     * WARNING - void declaration
     */
    void register(Method method) {
        for (Populate populate : (Populate[])this.annotationHandler_.getAnnotations(method, Populate.class)) {
            this.registerForPopulationFromScope(populate, method);
        }
        for (Annotation annotation : (In[])this.annotationHandler_.getAnnotations(method, In.class)) {
            this.registerForInjectionFromScope((In)annotation, method);
        }
        for (Annotation annotation : (Out[])this.annotationHandler_.getAnnotations(method, Out.class)) {
            this.registerForOutjectionToScope((Out)annotation, method);
        }
        Class<?>[] types = method.getParameterTypes();
        ScopeAttributeResolver[] resolvers = new ScopeAttributeResolver[types.length];
        for (int i = 0; i < types.length; ++i) {
            void var5_14;
            Populate[] ps;
            Object var5_12 = null;
            In[] is = (In[])this.annotationHandler_.getParameterAnnotations(method, i, In.class);
            if (is.length + (ps = (Populate[])this.annotationHandler_.getParameterAnnotations(method, i, Populate.class)).length > 0) {
                ScopeAttributeResolverImpl scopeAttributeResolverImpl = new ScopeAttributeResolverImpl(types[i], this.annotationHandler_.getMarkedParameterAnnotations(method, i, TypeConversionHint.class), this.scopeManager_, this.typeConversionManager_);
                for (In in : is) {
                    scopeAttributeResolverImpl.addEntry(this.getScope(in), in.name(), in.required());
                }
                for (Annotation annotation : ps) {
                    scopeAttributeResolverImpl.addEntry(this.getScope((Populate)annotation), annotation.name(), false);
                }
            }
            resolvers[i] = var5_14;
        }
        this.scopeAttributeResolversMap_.put(method, resolvers);
    }

    void registerForPopulationFromScope(Populate populate, Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @Populate can't annotate static method: class=" + this.class_.getName() + ", method=" + method);
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @Populate can annotate only public method: class=" + this.class_.getName() + ", method=" + method);
        }
        Scope scope = this.getScope(populate);
        ScopeAttributePopulatorImpl populator = this.scopeAttributePopulatorMap_.get(scope);
        if (populator == null) {
            populator = new ScopeAttributePopulatorImpl(scope, this.actionManager_, this.annotationHandler_, this.scopeManager_, this.typeConversionManager_);
            this.scopeAttributePopulatorMap_.put(scope, populator);
        }
        if (populate.name().length() == 0) {
            populator.addEntry(method, populate.populateWhereNull(), populate.actionName());
        } else {
            populator.addEntry(populate.name(), method, populate.populateWhereNull(), populate.actionName());
        }
    }

    void registerForInjectionFromScope(In in, Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @In can't annotate static method. @In usually annotates non-static setter method: class=" + this.class_.getName() + ", method=" + method);
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @In can annotate only public method. @In usually annotates public setter method: class=" + this.class_.getName() + ", method=" + method);
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalClientCodeRuntimeException("Logic error: @In can't annotate this method. @In usually annotates setter method: class=" + this.class_.getName() + ", method=" + method);
        }
        this.scopeAttributeInjectorList_.add(new ScopeAttributeInjectorImpl(this.toAttributeName(method.getName(), in.name()), method.getParameterTypes()[0], this.annotationHandler_.getMarkedAnnotations(method, TypeConversionHint.class), this.getScope(in), method, in.injectWhereNull(), in.required(), in.actionName(), this.actionManager_, this.scopeManager_));
    }

    Scope getScope(In in) {
        Object key = in.scopeName().length() > 0 ? this.normalizeScopeName(in.scopeName()) : (in.scopeClass() != Scope.class ? in.scopeClass() : (in.value() != Scope.class ? in.value() : this.normalizeScopeName(this.getDefaultScopeName())));
        return (Scope)this.getComponent(key);
    }

    Scope getScope(Populate populate) {
        Object key = populate.scopeName().length() > 0 ? this.normalizeScopeName(populate.scopeName()) : (populate.scopeClass() != Scope.class ? populate.scopeClass() : (populate.value() != Scope.class ? populate.value() : this.normalizeScopeName(this.getDefaultScopeName())));
        return (Scope)this.getComponent(key);
    }

    Scope getScope(Out out) {
        Object key = out.scopeName().length() > 0 ? this.normalizeScopeName(out.scopeName()) : (out.scopeClass() != Scope.class ? out.scopeClass() : (out.value() != Scope.class ? out.value() : this.normalizeScopeName(this.getDefaultScopeName())));
        return (Scope)this.getComponent(key);
    }

    private String getDefaultScopeName() {
        return this.applicationManager_.findContextApplication().getProperty("core.scope.defaultScopeName", "requestScope");
    }

    String normalizeScopeName(String scopeName) {
        if (scopeName != null && scopeName.length() > 0 && !scopeName.endsWith(SUFFIX_SCOPE)) {
            return scopeName + SUFFIX_SCOPE;
        }
        return scopeName;
    }

    void registerForOutjectionToScope(Out out, Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @Out can't annotate static method. @Out usually annotates non-static getter method: class=" + this.class_.getName() + ", method=" + method);
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalClientCodeRuntimeException("Logic error: @Out can annotate only public method. @Out usually annotates public getter method: class=" + this.class_.getName() + ", method=" + method);
        }
        if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) {
            throw new IllegalClientCodeRuntimeException("Logic error: @Out can't annotate this method. @Out usually annotates getter method: class=" + this.class_.getName() + ", method=" + method);
        }
        this.scopeAttributeOutjectorList_.add(new ScopeAttributeOutjectorImpl(this.toAttributeName(method.getName(), out.name()), this.getScope(out), method, out.outjectWhereNull(), out.actionName(), this.actionManager_));
    }

    String toAttributeName(String methodName, String explicitName) {
        if (explicitName != null && explicitName.length() > 0) {
            return explicitName;
        }
        return BeanUtils.toPropertyName(methodName, false);
    }

    Object getComponent(Object key) {
        return this.container_.getComponent(key);
    }

    @Override
    public ScopeAttributeResolver[] getScopeAttributeResolversForParameters(Method method) throws MethodNotFoundRuntimeException {
        ScopeAttributeResolver[] resolvers = this.scopeAttributeResolversMap_.get(method);
        if (resolvers != null) {
            return resolvers;
        }
        throw new MethodNotFoundRuntimeException().setMethod(method);
    }
}

