/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope.handler.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.scope.AttributeNotFoundRuntimeException;
import org.seasar.ymir.scope.Scope;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.scope.handler.ScopeAttributeInjector;
import org.seasar.ymir.scope.handler.impl.AbstractScopeAttributeHandler;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeAttributeInjectorImpl
extends AbstractScopeAttributeHandler
implements ScopeAttributeInjector {
    private Class<?> type_;
    private Annotation[] hint_;
    private boolean required_;
    private ScopeManager scopeManager_;
    private static final Log log_ = LogFactory.getLog(ScopeAttributeInjectorImpl.class);

    public ScopeAttributeInjectorImpl(String name, Class<?> type, Annotation[] hint, Scope scope, Method injectionMethod, boolean injectWhereNull, boolean required, String[] enabledActionNames, ActionManager actionManager, ScopeManager scopeManager) {
        super(name, scope, injectionMethod, injectWhereNull, enabledActionNames, actionManager);
        this.type_ = type;
        this.hint_ = hint;
        this.required_ = required;
        this.scopeManager_ = scopeManager;
    }

    @Override
    public void injectTo(Object component, String actionName) throws AttributeNotFoundRuntimeException {
        Object value;
        if (!this.isEnabled(actionName)) {
            return;
        }
        try {
            value = this.scopeManager_.getAttribute(this.scope_, this.name_, this.type_, this.hint_, this.required_, this.invokeWhereNull_);
        }
        catch (AttributeNotFoundRuntimeException ex) {
            throw ex.setMethod(this.method_).setComponent(component);
        }
        if (value != null || this.invokeWhereNull_) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)(ClassUtils.getPrettyName(this.scope_) + " -> " + ClassUtils.getPrettyName(component) + ": property=" + this.name_ + ", value=" + value));
            }
            boolean removeValue = false;
            try {
                this.method_.invoke(component, value);
            }
            catch (Throwable t) {
                removeValue = true;
                throw new IORuntimeException("Can't inject scope attribute: scope=" + this.scope_ + ", attribute name=" + this.name_ + ", value=" + value + ", write method=" + this.method_, t);
            }
            finally {
                if (removeValue) {
                    this.scope_.setAttribute(this.name_, null);
                }
            }
        }
    }
}

