/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.seasar.cms.pluggable.Configuration;
import org.seasar.cms.pluggable.hotdeploy.LocalHotdeployS2Container;
import org.seasar.framework.container.S2Container;
import org.seasar.ymir.PathMappingProvider;
import org.seasar.ymir.impl.AbstractApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleApplication
extends AbstractApplication {
    public static final String ID_DEFAULT = "";
    private ServletContext context_;
    private Configuration config_;
    private Class<?>[] referenceClasses_;
    private S2Container container_;
    private Map<Class<?>, Object> relatedObjectMap_;

    public SingleApplication(ServletContext context, Configuration config, Class<?> referenceClass, S2Container container, LocalHotdeployS2Container ondemandContainer, PathMappingProvider pathMappingProvider) {
        Class[] classArray;
        if (referenceClass != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = referenceClass;
        } else {
            classArray = new Class[]{};
        }
        this(context, config, classArray, container, ondemandContainer, pathMappingProvider);
    }

    public SingleApplication(ServletContext context, Configuration config, Class<?>[] referenceClasses, S2Container container, LocalHotdeployS2Container ondemandContainer, PathMappingProvider pathMappingProvider) {
        super(ID_DEFAULT, ondemandContainer, pathMappingProvider);
        this.relatedObjectMap_ = new ConcurrentHashMap();
        this.context_ = context;
        this.config_ = config;
        if (referenceClasses == null) {
            referenceClasses = new Class[]{};
        }
        this.referenceClasses_ = referenceClasses;
        this.container_ = container;
        for (Class<?> referenceClass : this.referenceClasses_) {
            ondemandContainer.addReferenceClassName(referenceClass.getName());
        }
    }

    @Override
    public S2Container getS2Container() {
        return this.container_;
    }

    @Override
    public Class<?>[] getReferenceClasses() {
        return this.referenceClasses_;
    }

    @Override
    public String getProperty(String key) {
        return this.config_.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.config_.getProperty(key, defaultValue);
    }

    @Override
    public Enumeration<String> propertyNames() {
        return this.config_.propertyNames();
    }

    @Override
    public void removeProperty(String key) {
        this.config_.removeProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream out, String header) throws IOException {
        Properties prop = new Properties();
        Configuration configuration = this.config_;
        synchronized (configuration) {
            Enumeration<String> enm = this.propertyNames();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement();
                if ("projectStatus".equals(name)) continue;
                prop.setProperty(name, this.config_.getProperty(name));
            }
        }
        prop.store(out, header);
    }

    @Override
    public void setProperty(String key, String value) {
        this.config_.setProperty(key, value);
    }

    @Override
    public boolean isUnderDevelopment() {
        return true;
    }

    @Override
    public boolean isResourceExists(String path) {
        try {
            return this.context_.getResource(path) != null;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    @Override
    public String getWebappRoot() {
        return this.context_.getRealPath(ID_DEFAULT);
    }

    @Override
    public <T> T getRelatedObject(Class<T> clazz) {
        return (T)this.relatedObjectMap_.get(clazz);
    }

    @Override
    public <T> void setRelatedObject(Class<T> clazz, T object) {
        if (object != null) {
            this.relatedObjectMap_.put(clazz, object);
        } else {
            this.relatedObjectMap_.remove(clazz);
        }
    }

    @Override
    public void clear() {
        this.relatedObjectMap_.clear();
    }
}

