/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.map.LruHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegexConstraint<T extends Annotation>
extends AbstractConstraint<T> {
    private Map<String, Pattern> compiledPatternMap_ = new LruHashMap<String, Pattern>(256);

    protected void confirm(Request request, T annotation, AnnotatedElement element, String[] property, String pattern, String messageKey, String namePrefixOnNote) throws ConstraintViolatedException {
        String[] names = this.getParameterNames(request, this.getPropertyName(element), property);
        if (names.length == 0) {
            return;
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Please specify either 'pattern' or 'value' property");
        }
        String fullMessageKey = this.getFullMessageKey(messageKey);
        Notes notes = new Notes();
        for (int i = 0; i < names.length; ++i) {
            this.confirm(request, annotation, names[i], fullMessageKey, namePrefixOnNote, pattern, notes);
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    void confirm(Request request, T annotation, String name, String fullMessageKey, String namePrefixOnNote, String pattern, Notes notes) {
        Pattern compiled = this.getCompiledPattern(pattern);
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length() == 0) continue;
            this.confirm(request, annotation, name, fullMessageKey, namePrefixOnNote, pattern, notes, values[i], compiled.matcher(values[i]));
        }
    }

    protected boolean confirm(Request request, T annotation, String name, String fullMessageKey, String namePrefixOnNote, String pattern, Notes notes, String value, Matcher matcher) {
        if (matcher.matches()) {
            return true;
        }
        notes.add(name, this.newNote(request, name, fullMessageKey, namePrefixOnNote, pattern, value));
        return false;
    }

    protected Note newNote(Request request, String name, String fullMessageKey, String namePrefixOnNote, String pattern, String value) {
        return new Note(fullMessageKey, namePrefixOnNote + name, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pattern getCompiledPattern(String pattern) {
        Pattern compiled = this.compiledPatternMap_.get(pattern);
        if (compiled == null) {
            compiled = Pattern.compile(pattern);
            Map<String, Pattern> map = this.compiledPatternMap_;
            synchronized (map) {
                this.compiledPatternMap_.put(pattern, compiled);
            }
        }
        return compiled;
    }
}

