/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.token.impl;

import javax.servlet.http.HttpSession;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.Request;
import org.seasar.ymir.session.SessionManager;
import org.seasar.ymir.token.Token;
import org.seasar.ymir.token.TokenManager;
import org.seasar.ymir.util.StringUtils;

public class TokenManagerImpl
implements TokenManager {
    private ApplicationManager applicationManager_;
    private SessionManager sessionManager_;
    private String tokenKey_;

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager_ = sessionManager;
    }

    public String getTokenKey() {
        if (this.tokenKey_ != null) {
            return this.tokenKey_;
        }
        return this.applicationManager_.findContextApplication().getProperty("core.token.key", "org.seasar.ymir.token");
    }

    @Binding(bindingType=BindingType.MAY)
    public void setTokenKey(String tokenKey) {
        this.tokenKey_ = tokenKey;
    }

    public Token newToken() {
        return new TokenImpl();
    }

    public String generateToken() {
        HttpSession session = this.sessionManager_.getSession();
        try {
            return StringUtils.getScopeKey(session.getId(), true);
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(String tokenKey) {
        HttpSession session = this.sessionManager_.getSession(false);
        if (session == null) {
            return null;
        }
        String string = session.getId().intern();
        synchronized (string) {
            return (String)session.getAttribute(tokenKey);
        }
    }

    public boolean isTokenValid(String tokenKey) {
        return this.isTokenValid(tokenKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTokenValid(String tokenKey, boolean reset) {
        HttpSession session = this.sessionManager_.getSession(false);
        if (session == null) {
            return false;
        }
        String string = session.getId().intern();
        synchronized (string) {
            String token;
            Object saved = session.getAttribute(tokenKey);
            if (saved == null) {
                return false;
            }
            if (reset) {
                this.resetToken(tokenKey);
            }
            if ((token = this.getRequest().getParameter(tokenKey)) == null) {
                return false;
            }
            return saved.equals(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToken(String tokenKey) {
        HttpSession session = this.sessionManager_.getSession(false);
        if (session != null) {
            String string = session.getId().intern();
            synchronized (string) {
                session.removeAttribute(tokenKey);
            }
        }
    }

    public void saveToken(String tokenKey) {
        this.saveToken(tokenKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToken(String tokenKey, boolean force) {
        HttpSession session = this.sessionManager_.getSession(false);
        if (!force && session != null && session.getAttribute(tokenKey) != null) {
            return;
        }
        if (session == null) {
            session = this.sessionManager_.getSession();
        }
        String string = session.getId().intern();
        synchronized (string) {
            String token = this.generateToken();
            if (token != null) {
                session.setAttribute(tokenKey, (Object)token);
            }
        }
    }

    protected Request getRequest() {
        return (Request)this.applicationManager_.findContextApplication().getS2Container().getComponent(Request.class);
    }

    protected class TokenImpl
    implements Token {
        protected TokenImpl() {
        }

        public boolean exists() {
            return TokenManagerImpl.this.getToken(TokenManagerImpl.this.getTokenKey()) != null;
        }

        public String getName() {
            return TokenManagerImpl.this.getTokenKey();
        }

        public String getValue() {
            TokenManagerImpl.this.saveToken(TokenManagerImpl.this.getTokenKey(), false);
            return TokenManagerImpl.this.getToken(TokenManagerImpl.this.getTokenKey());
        }
    }
}

