/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Set;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.ConfirmationDecider;
import org.seasar.ymir.constraint.Constraint;
import org.seasar.ymir.constraint.ConstraintType;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.annotation.ConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintBag<T extends Annotation> {
    private Constraint<T> constraint_;
    private T annotation_;
    private AnnotatedElement annotatedElement_;
    private ConfirmationDecider confirmationDecider_;
    private ConstraintType type_;

    public ConstraintBag(Constraint<T> constraint, T annotation, AnnotatedElement annotatedElement, ConfirmationDecider confirmationDecider) {
        this.constraint_ = constraint;
        this.annotation_ = annotation;
        this.annotatedElement_ = annotatedElement;
        this.confirmationDecider_ = confirmationDecider;
        ConstraintAnnotation constraintAnnotation = annotation.annotationType().getAnnotation(ConstraintAnnotation.class);
        this.type_ = constraintAnnotation.type();
    }

    public ConstraintBag(Constraint<T> constraint, ConstraintType type, ConfirmationDecider confirmationDecider) {
        this.constraint_ = constraint;
        this.confirmationDecider_ = confirmationDecider;
        this.type_ = type;
    }

    public void confirm(Object page, Request request, Set<ConstraintType> suppressTypeSet) throws ConstraintViolatedException {
        if (this.confirmationDecider_.isConfirmed(page, request, this.type_, suppressTypeSet)) {
            this.constraint_.confirm(page, request, this.annotation_, this.annotatedElement_);
        }
    }

    public Constraint<T> getConstraint() {
        return this.constraint_;
    }

    public T getAnnotation() {
        return this.annotation_;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement_;
    }

    public ConfirmationDecider getConfirmationDecider() {
        return this.confirmationDecider_;
    }

    public ConstraintType getType() {
        return this.type_;
    }
}

