/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.scope.AttributeNotFoundRuntimeException;
import org.seasar.ymir.scope.PopulationFailureException;
import org.seasar.ymir.scope.Scope;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.scope.ScopeMetaData;
import org.seasar.ymir.scope.handler.ScopeAttributeInjector;
import org.seasar.ymir.scope.handler.ScopeAttributeOutjector;
import org.seasar.ymir.scope.handler.ScopeAttributePopulator;
import org.seasar.ymir.scope.handler.ScopeAttributeResolver;
import org.seasar.ymir.scope.impl.ScopeMetaDataImpl;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeManagerImpl
implements ScopeManager {
    private static final Log log_ = LogFactory.getLog(ScopeManagerImpl.class);
    private ActionManager actionManager_;
    private ApplicationManager applicationManager_;
    private AnnotationHandler annotationHandler_;
    private HotdeployManager hotdeployManager_;
    private TypeConversionManager typeConversionManager_;
    private Map<Class<?>, ScopeMetaData> metaDataMap_;

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.metaDataMap_ = cacheManager.newMap();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setTypeConversionManager(TypeConversionManager typeConversionManager) {
        this.typeConversionManager_ = typeConversionManager;
    }

    @Override
    public <T> T getAttribute(Scope scope, String name, Class<T> type, boolean required, boolean convertNullToDefaultValueWhereTypeIsPrimitive) throws AttributeNotFoundRuntimeException {
        return this.getAttribute(scope, name, type, null, required, convertNullToDefaultValueWhereTypeIsPrimitive);
    }

    @Override
    public <T> T getAttribute(Scope scope, String name, Class<T> type, Annotation[] hint, boolean required, boolean convertNullToDefaultValueWhereTypeIsPrimitive) throws AttributeNotFoundRuntimeException {
        Class<?> componentType = ClassUtils.toComponentType(type);
        Object value = scope.getAttribute(name, componentType);
        if (required && value == null) {
            throw new AttributeNotFoundRuntimeException().setName(name).setType(componentType);
        }
        if (value != null && YmirContext.isUnderDevelopment()) {
            value = this.hotdeployManager_.fit(value);
        }
        if (value == null && !convertNullToDefaultValueWhereTypeIsPrimitive) {
            return null;
        }
        return this.typeConversionManager_.convert(value, type, hint);
    }

    protected ScopeMetaData getMetaData(Class<?> clazz) {
        ScopeMetaData metaData = this.metaDataMap_.get(clazz);
        if (metaData == null) {
            metaData = this.newInstance(clazz);
            this.metaDataMap_.put(clazz, metaData);
        }
        return metaData;
    }

    protected ScopeMetaData newInstance(Class<?> clazz) {
        return new ScopeMetaDataImpl(clazz, this.applicationManager_.findContextApplication().getS2Container(), this.actionManager_, this.annotationHandler_, this.applicationManager_, this, this.typeConversionManager_);
    }

    @Override
    public void populateScopeAttributes(PageComponent pageComponent, String actionName) {
        ScopeMetaData metaData = this.getMetaData(pageComponent.getPageClass());
        ScopeAttributePopulator[] populators = metaData.getScopeAttributePopulators();
        for (int i = 0; i < populators.length; ++i) {
            populators[i].populateTo(pageComponent.getPage(), actionName);
        }
    }

    @Override
    public void injectScopeAttributes(PageComponent pageComponent, String actionName) {
        ScopeMetaData metaData = this.getMetaData(pageComponent.getPageClass());
        ScopeAttributeInjector[] injectors = metaData.getScopeAttributeInjectors();
        for (int i = 0; i < injectors.length; ++i) {
            injectors[i].injectTo(pageComponent.getPage(), actionName);
        }
    }

    @Override
    public void outjectScopeAttributes(PageComponent pageComponent, String actionName) {
        ScopeMetaData metaData = this.getMetaData(pageComponent.getPageClass());
        ScopeAttributeOutjector[] outjectors = metaData.getScopeAttributeOutjectors();
        for (int i = 0; i < outjectors.length; ++i) {
            outjectors[i].outjectFrom(pageComponent.getPage(), actionName);
        }
    }

    @Override
    public Object[] resolveParameters(Class<?> pageClass, Method method, Object[] extendedParams) {
        Class<?>[] types = method.getParameterTypes();
        ScopeAttributeResolver[] resolvers = this.getMetaData(pageClass).getScopeAttributeResolversForParameters(method);
        Object[] params = new Object[types.length];
        int extendedParamsIdx = 0;
        for (int i = 0; i < types.length; ++i) {
            if (resolvers[i] != null) {
                params[i] = resolvers[i].getValue();
                continue;
            }
            Object value = null;
            if (extendedParamsIdx < extendedParams.length) {
                value = extendedParams[extendedParamsIdx++];
            }
            params[i] = this.typeConversionManager_.convert(value, types[i], this.annotationHandler_.getMarkedParameterAnnotations(method, i, TypeConversionHint.class));
        }
        return params;
    }

    @Override
    public void populate(Object bean, Map<String, ?> parameterMap) throws PopulationFailureException {
        this.populate0(bean, parameterMap, false);
    }

    public void populateQuietly(Object bean, Map<String, ? extends Object> parameterMap) {
        try {
            this.populate0(bean, parameterMap, true);
        }
        catch (PopulationFailureException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
    }

    protected void populate0(Object bean, Map<String, ?> parameterMap, boolean quietly) throws PopulationFailureException {
        if (bean == null || parameterMap == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : parameterMap.entrySet()) {
            this.populate0(bean, entry.getKey(), entry.getValue(), quietly);
        }
    }

    @Override
    public void populate(Object bean, String name, Object value) throws PopulationFailureException {
        this.populate0(bean, name, value, false);
    }

    @Override
    public void populateQuietly(Object bean, String name, Object value) {
        try {
            this.populate0(bean, name, value, true);
        }
        catch (PopulationFailureException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
    }

    protected void populate0(Object bean, String name, Object value, boolean quietly) throws PopulationFailureException {
        block4: {
            PropertyHandler handler = this.typeConversionManager_.getPropertyHandler(bean, name);
            if (handler == null || handler.getWriteMethod() == null) {
                return;
            }
            Object converted = this.typeConversionManager_.convert(value, handler.getPropertyType(), this.annotationHandler_.getMarkedAnnotations(handler.getWriteMethod(), TypeConversionHint.class));
            try {
                handler.setProperty(converted);
            }
            catch (Throwable t) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("Can't populate: property name=" + name + ", value=" + value + ", write method=" + handler.getWriteMethod()), t);
                }
                if (quietly) break block4;
                throw new PopulationFailureException(name, value, handler, t);
            }
        }
    }
}

