/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.beantable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.ymir.beantable.BeantableManager;

public class BeantableClassHandler
implements ClassTraversal.ClassHandler {
    private Log log_ = LogFactory.getLog(BeantableClassHandler.class);
    private BeantableManager manager_;

    @Binding(bindingType=BindingType.MUST, value="beantableManager")
    public void setBeantableManager(BeantableManager manager) {
        this.manager_ = manager;
    }

    public void processClass(String packageName, String shortClassName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        String className = packageName + "." + shortClassName;
        try {
            this.manager_.enableBeantable(Class.forName(className, true, cl), false);
        }
        catch (ClassNotFoundException ex) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("[SKIP] Class not found: " + className));
            }
            return;
        }
    }
}

