/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.util.Arrays;
import org.seasar.ymir.Application;
import org.seasar.ymir.convention.YmirNamingConvention;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;

public class SystemInformation {
    private Application application_;
    private String[] hotDeployEnabledPackageNames_ = new String[0];
    private String[] hotDeployDisabledPackageNames_ = new String[0];

    public SystemInformation(Application application, YmirNamingConvention namingConvention) {
        this.application_ = application;
        this.initialize(namingConvention);
    }

    void initialize(YmirNamingConvention namingConvention) {
        if (namingConvention == null) {
            return;
        }
        if (namingConvention.isHotdeployableOnlyPackageForCreator()) {
            this.hotDeployEnabledPackageNames_ = namingConvention.getTargetPackageNames();
        } else {
            this.hotDeployEnabledPackageNames_ = namingConvention.getRootPackageNames();
            this.hotDeployDisabledPackageNames_ = namingConvention.getIgnorePackageNames();
        }
        Arrays.sort(this.hotDeployEnabledPackageNames_);
        Arrays.sort(this.hotDeployDisabledPackageNames_);
    }

    public String[] getHotdeployEnabledPackageNames() {
        return this.hotDeployEnabledPackageNames_;
    }

    public String[] getHotdeployDisabledPackageNames() {
        return this.hotDeployDisabledPackageNames_;
    }

    public Application getApplication() {
        return this.application_;
    }

    public boolean isProjectRootDetectedAutomatically() {
        return SourceCreatorUtils.getProjectRootFromLocalProperties(this.application_) == null && SourceCreatorUtils.getProjectRootFromProperties(this.application_) == null;
    }
}

