/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render.html;

import org.seasar.ymir.render.html.Tag;
import org.seasar.ymir.util.HTMLUtils;

public class Option
extends Tag {
    private static final long serialVersionUID = 1L;
    private boolean disabled_;
    private boolean selected_;
    private String value_;
    private String label_;

    public Option() {
    }

    public Option(Object value) {
        this(value, value);
    }

    public Option(Object value, Object content) {
        this.value_ = value != null ? value.toString() : null;
        this.setContent(content);
    }

    protected void writeName(StringBuilder sb) {
        sb.append("option");
    }

    protected void writeAttributes(StringBuilder sb) {
        super.writeAttributes(sb);
        if (this.label_ != null) {
            sb.append(" label=\"").append(HTMLUtils.filter(this.label_)).append("\"");
        }
        if (this.value_ != null) {
            sb.append(" value=\"").append(HTMLUtils.filter(this.value_)).append("\"");
        }
        if (this.selected_) {
            sb.append(" selected=\"selected\"");
        }
        if (this.disabled_) {
            sb.append(" disabled=\"disabled\"");
        }
    }

    public String getValue() {
        return this.value_;
    }

    public Integer getValueAsInteger() {
        if (this.value_ == null) {
            return null;
        }
        return Integer.valueOf(this.value_);
    }

    public Option setValue(Object value) {
        this.value_ = value != null ? value.toString() : null;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled_;
    }

    public Option setDisabled(boolean disabled) {
        this.disabled_ = disabled;
        return this;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public Option setSelected(boolean selected) {
        this.selected_ = selected;
        return this;
    }

    public String getLabel() {
        return this.label_;
    }

    public Option setLabel(String label) {
        this.label_ = label;
        return this;
    }
}

