/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.lang.reflect.AnnotatedElement;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.Numeric;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericConstraint
extends AbstractConstraint<Numeric> {
    @Override
    protected String getConstraintKey() {
        return "numeric";
    }

    @Override
    public void confirm(Object component, Request request, Numeric annotation, AnnotatedElement element) throws ConstraintViolatedException {
        String[] names = this.getParameterNames(request, this.getPropertyName(element), annotation.value(), annotation.property());
        if (names.length == 0) {
            return;
        }
        boolean integer = annotation.integer();
        boolean greaterIncludeEqual = false;
        Double greaterEdge = annotation.greaterThan();
        if (greaterEdge == -1.7976931348623157E308) {
            greaterEdge = annotation.greaterEqual();
            greaterIncludeEqual = true;
            if (greaterEdge == -1.7976931348623157E308) {
                greaterEdge = null;
            }
        }
        boolean lessIncludeEqual = false;
        Double lessEdge = annotation.lessThan();
        if (lessEdge == Double.MAX_VALUE) {
            lessEdge = annotation.lessEqual();
            lessIncludeEqual = true;
            if (lessEdge == Double.MAX_VALUE) {
                lessEdge = null;
            }
        }
        Notes notes = new Notes();
        for (int i = 0; i < names.length; ++i) {
            this.confirm(request, names[i], integer, greaterEdge, greaterIncludeEqual, lessEdge, lessIncludeEqual, notes, annotation.messageKey(), annotation.namePrefixOnNote());
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    void confirm(Request request, String name, boolean integer, Double greaterEdge, boolean greaterIncludeEqual, Double lessEdge, boolean lessIncludeEqual, Notes notes, String messageKey, String namePrefixOnNote) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            double value;
            if (values[i].length() == 0) continue;
            try {
                value = Double.parseDouble(values[i]);
            }
            catch (NumberFormatException ex) {
                notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey(), messageKey), namePrefixOnNote + name));
                continue;
            }
            if (integer && values[i].indexOf(46) >= 0) {
                notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + ".integer", messageKey), namePrefixOnNote + name, lessEdge, greaterEdge));
            }
            if (greaterEdge != null) {
                if (greaterIncludeEqual) {
                    if (value < greaterEdge) {
                        notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + ".greaterEqual", messageKey), namePrefixOnNote + name, greaterEdge, lessEdge));
                    }
                } else if (value <= greaterEdge) {
                    notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + ".greaterThan", messageKey), namePrefixOnNote + name, greaterEdge, lessEdge));
                }
            }
            if (lessEdge == null) continue;
            if (lessIncludeEqual) {
                if (!(value > lessEdge)) continue;
                notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + ".lessEqual", messageKey), namePrefixOnNote + name, lessEdge, greaterEdge));
                continue;
            }
            if (!(value >= lessEdge)) continue;
            notes.add(name, new Note(ConstraintUtils.getFullMessageKey(this.getConstraintKey() + ".lessThan", messageKey), namePrefixOnNote + name, lessEdge, greaterEdge));
        }
    }
}

