/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.dbflute.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.dbflute.EntityManager;
import org.seasar.ymir.dbflute.util.DBFluteUtils;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements EntityManager {
    @Binding(bindingType=BindingType.MUST)
    protected ApplicationManager applicationManager;
    @Binding(bindingType=BindingType.MUST)
    protected TypeConversionManager typeConversionManager;
    private Map<String, Class<? extends Entity>> entityClassMap;
    private Map<Class<? extends Entity>, BehaviorWritable> behaviorMap;
    private Map<Class<? extends Entity>, Class<? extends ConditionBean>> conditionBeanClassMap;
    private Map<Class<? extends Entity>, DBMeta> dbMetaMap;
    private Map<Class<? extends Entity>, List<String>> primaryKeyColumnNamesMap;
    private Map<Class<? extends Entity>, List<ForeignInfo>> childForeignInfoMap;

    @InitMethod
    public void initialize() {
        this.entityClassMap = new HashMap<String, Class<? extends Entity>>();
        this.behaviorMap = new HashMap<Class<? extends Entity>, BehaviorWritable>();
        this.conditionBeanClassMap = new HashMap<Class<? extends Entity>, Class<? extends ConditionBean>>();
        this.dbMetaMap = new HashMap<Class<? extends Entity>, DBMeta>();
        this.primaryKeyColumnNamesMap = new HashMap<Class<? extends Entity>, List<String>>();
        this.childForeignInfoMap = new HashMap<Class<? extends Entity>, List<ForeignInfo>>();
        for (BehaviorWritable bhv : (BehaviorWritable[])this.applicationManager.findContextApplication().getS2Container().findComponents(BehaviorWritable.class)) {
            Class cbClass;
            Class entityClass;
            String bhvClassName = bhv.getClass().getName();
            String packageName = bhvClassName.substring(0, bhvClassName.lastIndexOf(46, bhvClassName.lastIndexOf(46) - 1));
            DBMeta dbMeta = bhv.getDBMeta();
            String entityName = dbMeta.getTablePropertyName();
            if (this.entityClassMap.containsKey(entityName)) continue;
            String cEntityName = BeanUtils.capitalize((String)entityName);
            String entityClassName = packageName + ".exentity." + cEntityName;
            try {
                entityClass = ClassUtils.forName((String)entityClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Entity class corresponding to '" + bhvClassName + "' not found: " + entityClassName, ex);
            }
            String cbClassName = packageName + ".cbean." + cEntityName + "CB";
            try {
                cbClass = ClassUtils.forName((String)cbClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Cannot find ConditionBean class: " + cbClassName);
            }
            this.entityClassMap.put(entityName, entityClass);
            this.dbMetaMap.put(entityClass, dbMeta);
            this.behaviorMap.put(entityClass, bhv);
            this.conditionBeanClassMap.put(entityClass, cbClass);
            ArrayList<String> primaryKeyColumnNames = new ArrayList<String>();
            UniqueInfo uniqueInfo = dbMeta.getPrimaryUniqueInfo();
            for (ColumnInfo columnInfo : uniqueInfo.getUniqueColumnList()) {
                primaryKeyColumnNames.add(columnInfo.getPropertyName());
            }
            this.primaryKeyColumnNamesMap.put(entityClass, Collections.unmodifiableList(primaryKeyColumnNames));
        }
        for (DBMeta dbMeta : this.dbMetaMap.values()) {
            for (ForeignInfo info : dbMeta.getForeignInfoList()) {
                Class<? extends Entity> foreignEntityClass = this.entityClassMap.get(info.getForeignDBMeta().getTablePropertyName());
                List<ForeignInfo> list = this.childForeignInfoMap.get(foreignEntityClass);
                if (list == null) {
                    list = new ArrayList<ForeignInfo>();
                    this.childForeignInfoMap.put(foreignEntityClass, list);
                }
                list.add(info);
            }
        }
        this.entityClassMap = Collections.unmodifiableMap(this.entityClassMap);
        this.behaviorMap = Collections.unmodifiableMap(this.behaviorMap);
        this.conditionBeanClassMap = Collections.unmodifiableMap(this.conditionBeanClassMap);
        this.dbMetaMap = Collections.unmodifiableMap(this.dbMetaMap);
        this.primaryKeyColumnNamesMap = Collections.unmodifiableMap(this.primaryKeyColumnNamesMap);
        this.childForeignInfoMap = Collections.unmodifiableMap(this.childForeignInfoMap);
    }

    @Override
    public Class<? extends Entity> getEntityClass(String entityName) {
        if (entityName == null) {
            return null;
        }
        return this.entityClassMap.get(this.normalizeEntityName(entityName));
    }

    String normalizeEntityName(String entityName) {
        if (entityName == null) {
            return null;
        }
        if (entityName.indexOf(95) >= 0) {
            return DBFluteUtils.camelize(entityName);
        }
        if (entityName.length() > 0 && Character.isUpperCase(entityName.charAt(0))) {
            return entityName.toLowerCase();
        }
        return entityName;
    }

    @Override
    public Entity newEntity(String entityName) {
        return this.newEntity(this.getEntityClass(entityName));
    }

    @Override
    public Entity newEntity(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            return null;
        }
        try {
            return entityClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public BehaviorWritable getBehavior(String entityName) {
        return this.getBehavior(this.getEntityClass(entityName));
    }

    @Override
    public BehaviorWritable getBehavior(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            return null;
        }
        return this.behaviorMap.get(entityClass);
    }

    @Override
    public ConditionBean newConditionBean(String entityName) {
        return this.newConditionBean(this.getEntityClass(entityName));
    }

    @Override
    public ConditionBean newConditionBean(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            return null;
        }
        Class<? extends ConditionBean> cbClass = this.conditionBeanClassMap.get(entityClass);
        if (cbClass == null) {
            return null;
        }
        try {
            return cbClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public DBMeta getDBMeta(String entityName) {
        return this.getDBMeta(this.getEntityClass(entityName));
    }

    @Override
    public DBMeta getDBMeta(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            return null;
        }
        return this.dbMetaMap.get(entityClass);
    }

    @Override
    public ColumnInfo getColumnInfo(String entityName, String columnName) {
        return this.getColumnInfo(this.getEntityClass(entityName), columnName);
    }

    @Override
    public ColumnInfo getColumnInfo(Class<? extends Entity> entityClass, String columnName) {
        if (entityClass == null) {
            return null;
        }
        DBMeta dbMeta = this.getDBMeta(entityClass);
        if (dbMeta == null) {
            return null;
        }
        try {
            return dbMeta.findColumnInfo(columnName);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    @Override
    public List<String> getPrimaryKeyColumnNames(String entityName) {
        return this.getPrimaryKeyColumnNames(this.getEntityClass(entityName));
    }

    @Override
    public List<String> getPrimaryKeyColumnNames(Class<? extends Entity> entityClass) {
        List<String> primaryKeyColumnNames = null;
        if (entityClass != null) {
            primaryKeyColumnNames = this.primaryKeyColumnNamesMap.get(entityClass);
        }
        if (primaryKeyColumnNames == null) {
            primaryKeyColumnNames = Collections.emptyList();
        }
        return primaryKeyColumnNames;
    }

    @Override
    public List<ForeignInfo> getChildForeignInfos(String entityName) {
        return this.getChildForeignInfos(this.getEntityClass(entityName));
    }

    @Override
    public List<ForeignInfo> getChildForeignInfos(Class<? extends Entity> entityClass) {
        List<ForeignInfo> childForeignInfos = null;
        if (entityClass != null) {
            childForeignInfos = this.childForeignInfoMap.get(entityClass);
        }
        if (childForeignInfos == null) {
            childForeignInfos = Collections.emptyList();
        }
        return childForeignInfos;
    }

    @Override
    public void setValue(ConditionBean cb, String columnName, ConditionKey key, Object value) {
        if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
            return;
        }
        ColumnInfo columnInfo = this.getColumnInfo(cb.getTableDbName(), columnName);
        if (columnInfo == null) {
            return;
        }
        cb.localCQ().invokeQuery(columnName, key.getConditionKey(), this.typeConversionManager.convert(value, columnInfo.getPropertyType()));
    }
}

