/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response.constructor.impl;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.seasar.ymir.Response;
import org.seasar.ymir.response.VoidResponse;
import org.seasar.ymir.response.constructor.ResponseConstructor;
import org.seasar.ymir.response.constructor.ResponseConstructorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectResponseConstructor
implements ResponseConstructor<Object> {
    private ResponseConstructorSelector responseConstructorSelector_;

    @Override
    public Class<Object> getTargetClass() {
        return Object.class;
    }

    @Override
    public Response constructResponse(Object page, Object returnValue) {
        if (returnValue == null) {
            return VoidResponse.INSTANCE;
        }
        ResponseConstructor<Object> responseConstructor = this.findResponseConstructor(returnValue.getClass());
        if (responseConstructor == null) {
            if (this.responseConstructorSelector_.hasResponseConstructor(String.class)) {
                responseConstructor = this.responseConstructorSelector_.getResponseConstructor(String.class);
                returnValue = returnValue.toString();
            } else {
                throw new RuntimeException("Can't construct response for return value: class=" + returnValue.getClass() + ", value=" + returnValue);
            }
        }
        return responseConstructor.constructResponse(page, returnValue);
    }

    ResponseConstructor<?> findResponseConstructor(Class<?> clazz) {
        if (clazz == Object.class) {
            return null;
        }
        LinkedHashSet interfaceSet = new LinkedHashSet();
        if (clazz.isInterface()) {
            if (this.responseConstructorSelector_.hasResponseConstructor(clazz)) {
                return this.responseConstructorSelector_.getResponseConstructor(clazz);
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            interfaceSet.addAll(Arrays.asList(interfaces));
        } else {
            Class<?> type = clazz;
            do {
                if (this.responseConstructorSelector_.hasResponseConstructor(type)) {
                    return this.responseConstructorSelector_.getResponseConstructor(type);
                }
                Class<?>[] classArray = type.getInterfaces();
                interfaceSet.addAll(Arrays.asList(classArray));
            } while ((type = type.getSuperclass()) != Object.class);
        }
        for (Class clazz2 : interfaceSet) {
            ResponseConstructor<?> constructor = this.findResponseConstructor(clazz2);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    public void setResponseConstructorSelector(ResponseConstructorSelector responseConstructorSelector) {
        this.responseConstructorSelector_ = responseConstructorSelector;
    }
}

