/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.TemplateContext;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class TagRenderingInterceptorChainImpl
implements TagRenderingInterceptorChain {
    private TagRenderingInterceptor tagRenderingInterceptor_;
    private TagRenderingInterceptorChain chain_;
    private Pattern[] tagPatterns_;
    private Pattern[] attrPatterns_;

    public TagRenderingInterceptorChainImpl(TagRenderingInterceptor tagRenderingInterceptor, TagRenderingInterceptorChain chain) {
        this.tagRenderingInterceptor_ = tagRenderingInterceptor;
        this.chain_ = chain;
        this.tagPatterns_ = this.compilePatterns(tagRenderingInterceptor.getSpecialTagPatternStrings());
        this.attrPatterns_ = this.compilePatterns(tagRenderingInterceptor.getSpecialAttributePatternStrings());
    }

    Pattern[] compilePatterns(String[] patternStrings) {
        if (patternStrings == null) {
            return new Pattern[0];
        }
        Pattern[] patterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                patterns[i] = Pattern.compile(patternStrings[i]);
                continue;
            }
            catch (PatternSyntaxException ex) {
                throw (IllegalArgumentException)new IllegalArgumentException("Syntax error: " + patternStrings[i]).initCause(ex);
            }
        }
        return patterns;
    }

    boolean isSpecialTag(String tagName) {
        for (int i = 0; i < this.tagPatterns_.length; ++i) {
            Matcher m = this.tagPatterns_[i].matcher(tagName);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    boolean isSpecialAttribute(String attrName) {
        for (int i = 0; i < this.attrPatterns_.length; ++i) {
            Matcher m = this.attrPatterns_[i].matcher(attrName);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body) {
        if (this.shouldProcess(name, attributes)) {
            return this.tagRenderingInterceptor_.render(context, name, attributes, body, this.chain_);
        }
        return this.chain_.render(context, name, attributes, body);
    }

    boolean shouldProcess(String name, Attribute[] attributes) {
        if (this.isSpecialTag(name)) {
            return true;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!this.isSpecialAttribute(attributes[i].getName())) continue;
            return true;
        }
        return false;
    }
}

