/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClassType {
    BEAN("", true),
    PAGE("Page", false),
    DTO("Dto", false),
    DAO("Dao", true),
    DXO("Dxo", true),
    CONVERTER("Converter", true);

    public static final String SUFFIX_BASE = "Base";
    private String suffix_;
    private boolean subordinate_;
    private static final Map<String, ClassType> enumMap_;

    private ClassType(String suffix, boolean subordinate) {
        this.suffix_ = suffix;
        this.subordinate_ = subordinate;
    }

    public String getSuffix() {
        return this.suffix_;
    }

    public boolean isSubordinate() {
        return this.subordinate_;
    }

    public static ClassType enumOf(String suffix) {
        return enumMap_.get(suffix);
    }

    public static ClassType typeOfClass(Class<?> clazz) {
        String className = null;
        if (clazz != null) {
            className = clazz.getName();
        }
        return ClassType.typeOfClass(className);
    }

    public static ClassType typeOfClass(String className) {
        if (className == null) {
            return null;
        }
        String baseName = className.endsWith(SUFFIX_BASE) ? className.substring(0, className.length() - SUFFIX_BASE.length()) : className;
        for (ClassType classType : ClassType.values()) {
            if (classType == BEAN || !baseName.endsWith(classType.getSuffix())) continue;
            return classType;
        }
        return BEAN;
    }

    static {
        HashMap<String, ClassType> enumMap = new HashMap<String, ClassType>();
        for (ClassType enm : ClassType.values()) {
            enumMap.put(enm.getSuffix(), enm);
        }
        enumMap_ = Collections.unmodifiableMap(enumMap);
    }
}

