/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.window.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.Path;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.session.SessionManager;
import org.seasar.ymir.util.ResponseUtils;
import org.seasar.ymir.window.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowManagerImpl
implements WindowManager {
    public static final String ATTRPREFIX_WINDOW = "org.seasar.ymir.window.";
    public static final String ATTRPREFIX_WINDOW_WINDOWID = "org.seasar.ymir.window.windowId.";
    private static final String DEFAULT_WINDOWID = "_self";
    private ApplicationManager applicationManager_;
    private HotdeployManager hotdeployManager_;
    private SessionManager sessionManager_;
    private String windowIdKey_;

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager_ = sessionManager;
    }

    @Override
    public void addStraddlingAttributeNamePattern(String namePattern) {
        this.sessionManager_.addStraddlingAttributeNamePattern(namePattern);
    }

    @Binding(bindingType=BindingType.MAY)
    public void setWindowIdKey(String windowIdKey) {
        this.windowIdKey_ = windowIdKey;
    }

    @Override
    public String getWindowIdKey() {
        if (this.windowIdKey_ != null) {
            return this.windowIdKey_;
        }
        return this.applicationManager_.findContextApplication().getProperty("core.window.key", "org.seasar.ymir.window");
    }

    Map<String, Object> getScopeMap(String windowId, boolean create) {
        String key = this.getKey(windowId);
        HashMap scopeMap = (HashMap)this.sessionManager_.getAttribute(key);
        if (scopeMap == null && create) {
            scopeMap = new HashMap();
            this.sessionManager_.setAttribute(key, scopeMap);
        }
        return scopeMap;
    }

    void removeScopeMap(String windowId) {
        this.sessionManager_.setAttribute(this.getKey(windowId), null);
    }

    String getKey(String windowId) {
        if (windowId == null) {
            return null;
        }
        return ATTRPREFIX_WINDOW_WINDOWID + windowId;
    }

    @Override
    public <T> T getScopeAttribute(String name) {
        T value = this.getScopeAttribute(this.findWindowId(), name);
        return value;
    }

    @Override
    public <T> T getScopeAttribute(String windowId, String name) {
        Object value = this.getRawScopeAttribute(windowId, name);
        if (value != null && YmirContext.isUnderDevelopment()) {
            value = this.hotdeployManager_.fit(value);
        }
        return value;
    }

    @Override
    public <T> T getRawScopeAttribute(String name) {
        T value = this.getRawScopeAttribute(this.findWindowId(), name);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getRawScopeAttribute(String windowId, String name) {
        String string = windowId.intern();
        synchronized (string) {
            Map<String, Object> scopeMap = this.getScopeMap(windowId, false);
            if (scopeMap == null) {
                return null;
            }
            return (T)scopeMap.get(name);
        }
    }

    @Override
    public Iterator<String> getScopeAttributeNames() {
        return this.getScopeAttributeNames(this.findWindowId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getScopeAttributeNames(String windowId) {
        String string = windowId.intern();
        synchronized (string) {
            Map<String, Object> scopeMap = this.getScopeMap(windowId, false);
            if (scopeMap == null) {
                return new ArrayList().iterator();
            }
            return scopeMap.keySet().iterator();
        }
    }

    @Override
    public boolean existsWindowScope() {
        return this.existsWindowScope(this.findWindowId());
    }

    @Override
    public boolean existsWindowScope(String windowId) {
        return this.sessionManager_.getSession(false) != null;
    }

    @Override
    public String findWindowId() {
        String windowId = this.getWindowId();
        if (windowId == null) {
            windowId = DEFAULT_WINDOWID;
        }
        return windowId;
    }

    @Override
    public String getWindowId() {
        Request request = (Request)this.getS2Container().getComponent(Request.class);
        if (request == null) {
            return null;
        }
        return request.getParameter(this.getWindowIdKey());
    }

    S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    @Override
    public void setScopeAttribute(String name, Object value) {
        this.setScopeAttribute(this.findWindowId(), name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScopeAttribute(String windowId, String name, Object value) {
        String string = windowId.intern();
        synchronized (string) {
            if (value != null) {
                this.getScopeMap(windowId, true).put(name, value);
            } else {
                Map<String, Object> scopeMap = this.getScopeMap(windowId, false);
                if (scopeMap == null) {
                    return;
                }
                scopeMap.remove(name);
                if (scopeMap.isEmpty()) {
                    this.removeScopeMap(windowId);
                }
            }
        }
    }

    @Override
    public String findWindowIdForNextRequest() {
        String windowId = this.getWindowIdForNextRequest();
        if (windowId == null) {
            windowId = DEFAULT_WINDOWID;
        }
        return windowId;
    }

    @Override
    public String getWindowIdForNextRequest() {
        Response response = (Response)this.getS2Container().getComponent(Response.class);
        if (response != null && (ResponseUtils.isProceed(response) || response.getType() == ResponseType.REDIRECT)) {
            String[] value = new Path(response.getPath()).getParameterMap().get(this.getWindowIdKey());
            if (value != null && value.length > 0) {
                return value[0];
            }
            return null;
        }
        return this.getWindowId();
    }
}

