/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.impl.DateConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimestampConverter
extends DateConverterBase<Timestamp> {
    public static final String PATTERN = "yyyy-MM-dd HH:mm:ss.fffffffff";
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.fffffffff", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"};

    public SqlTimestampConverter() {
        this.type_ = Timestamp.class;
        this.pattern_ = PATTERN;
    }

    @Override
    protected Timestamp doConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        String pattern = this.getPatternOrNull(hint);
        if (pattern == null) {
            Exception cause = null;
            for (String ptn : PATTERNS) {
                try {
                    return this.convertToTimestamp(value, ptn);
                }
                catch (Exception ex) {
                    cause = ex;
                }
            }
            throw new TypeConversionException(cause, value, this.getType());
        }
        try {
            return this.convertToTimestamp(value, pattern);
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex, value, this.getType());
        }
    }

    private Timestamp convertToTimestamp(Object value, String pattern) throws IllegalArgumentException, ParseException {
        if (pattern.equals(PATTERN)) {
            return Timestamp.valueOf(value.toString());
        }
        return new Timestamp(new SimpleDateFormat(pattern).parse(value.toString()).getTime());
    }

    @Override
    public String convertToString(Timestamp value, Annotation[] hint) {
        String pattern = this.getPattern(hint);
        if (pattern.equals(PATTERN)) {
            return value.toString();
        }
        return new SimpleDateFormat(this.getPattern(hint)).format(value);
    }
}

