/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

public class HTMLUtils {
    protected HTMLUtils() {
    }

    public static String filterLines(String text) {
        return HTMLUtils.filterLines(text, false);
    }

    public static String filterLines(String text, boolean toNbsp) {
        char ch;
        if (text == null) {
            return null;
        }
        boolean endsWithSeparator = false;
        int n = text.length();
        if (n > 0 && ((ch = text.charAt(n - 1)) == '\r' || ch == '\n')) {
            endsWithSeparator = true;
        }
        String separator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String delim = "";
        StringReader sr = new StringReader(text);
        BufferedReader in = new BufferedReader(sr);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(delim);
                delim = toNbsp ? "<br />" + separator : separator;
                sb.append(HTMLUtils.filter(line, toNbsp));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (endsWithSeparator) {
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String filter(String line) {
        return HTMLUtils.filter(line, false);
    }

    public static String filter(String line, boolean toNbsp) {
        if (line == null) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(line, "&<> \"'", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String encode = token.equals("&") ? "&amp;" : (token.equals("<") ? "&lt;" : (token.equals(">") ? "&gt;" : (token.equals(" ") ? (toNbsp ? "&nbsp;" : " ") : (token.equals("\"") ? "&quot;" : (token.equals("'") ? "&#39;" : token)))));
            sb.append(encode);
        }
        return sb.toString();
    }

    public static String defilter(String html) {
        if (html == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        HTMLUtils.defilter(sb, html);
        return sb.toString();
    }

    public static void defilter(StringBuffer sb, String html) {
        int idx;
        String htmlLowerCase = html.toLowerCase();
        int pre = 0;
        while ((idx = html.indexOf("&", pre)) >= 0) {
            String decode;
            sb.append(html.substring(pre, idx));
            int semi = html.indexOf(";", idx + 1);
            if (semi < 0) {
                pre = idx;
                break;
            }
            String tkn = htmlLowerCase.substring(idx + 1, semi);
            if (tkn.equals("amp")) {
                decode = "&";
            } else if (tkn.equals("lt")) {
                decode = "<";
            } else if (tkn.equals("gt")) {
                decode = ">";
            } else if (tkn.equals("nbsp")) {
                decode = " ";
            } else if (tkn.equals("quot")) {
                decode = "\"";
            } else if (tkn.equals("apos")) {
                decode = "'";
            } else if (tkn.startsWith("#")) {
                String code = tkn.substring(1);
                int radix = 10;
                if (code.startsWith("x")) {
                    code = code.substring(1);
                    radix = 16;
                }
                try {
                    decode = String.valueOf((char)Integer.parseInt(code, radix));
                }
                catch (Throwable t) {
                    decode = html.substring(idx, semi + 1);
                }
            } else {
                decode = html.substring(idx, semi + 1);
            }
            sb.append(decode);
            pre = semi + 1;
        }
        sb.append(html.substring(pre));
    }
}

