/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.batch;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.kvasir.util.io.Resource;
import org.seasar.kvasir.util.io.impl.FileResource;
import org.seasar.ymir.batch.Batch;
import org.seasar.ymir.batch.util.BatchUtils;
import org.seasar.ymir.mock.servlet.MockServletContext;
import org.seasar.ymir.mock.servlet.MockServletContextImpl;
import org.seasar.ymir.servlet.YmirListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchLauncher
implements Batch {
    private final Log log = LogFactory.getLog(this.getClass());
    private MockServletContext servletContext;
    private YmirListener listener;
    private S2Container container;
    private Class<? extends Batch> batchClass;
    private String batchComponentName;
    private Batch batch;

    public BatchLauncher(Class<? extends Batch> batchClass) {
        this.batchClass = batchClass;
    }

    public BatchLauncher(String batchComponentName) {
        this.batchComponentName = batchComponentName;
    }

    @Override
    public final boolean init(String[] args) throws Exception {
        this.servletContext = new MockServletContextImpl("/");
        this.servletContext.setRoot((Resource)new FileResource(BatchUtils.getBatchHome().getParentFile()));
        this.servletContext.setInitParameter("org.seasar.framework.container.configPath", "ymir.dicon");
        this.listener = new YmirListener();
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)this.servletContext));
        this.container = SingletonS2ContainerFactory.getContainer();
        this.batch = this.batchClass != null ? (Batch)this.container.getComponent(this.batchClass) : (Batch)this.container.getComponent((Object)this.batchComponentName);
        return this.batch.init(args);
    }

    @Override
    public final int execute() throws Exception {
        return this.batch.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() throws Exception {
        try {
            this.batch.destroy();
        }
        finally {
            this.listener.contextDestroyed(new ServletContextEvent((ServletContext)this.servletContext));
        }
    }

    public S2Container getContainer() {
        return this.container;
    }
}

