/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.util.HashSet;
import java.util.Set;
import org.seasar.kvasir.util.StringUtils;
import org.seasar.ymir.annotation.Meta;
import org.seasar.ymir.extension.creator.MetaAnnotationDesc;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationDescImpl
implements MetaAnnotationDesc {
    private String metaName_;
    private String[] metaValue_;
    private Class<?>[] metaClassValue_;
    private Set<String> touchedClassNameSet_ = new HashSet<String>();

    public MetaAnnotationDescImpl(Meta meta) {
        this(meta.name(), meta.value(), meta.classValue());
    }

    public MetaAnnotationDescImpl(String metaName, String[] metaValue) {
        this(metaName, metaValue, new Class[0]);
    }

    public MetaAnnotationDescImpl(String metaName, Class<?>[] metaClassValue) {
        this(metaName, new String[0], metaClassValue);
    }

    public MetaAnnotationDescImpl(String metaName, String[] metaValue, Class<?>[] metaClassValue) {
        this.metaName_ = metaName;
        this.metaValue_ = metaValue;
        this.metaClassValue_ = metaClassValue;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.getAsString();
    }

    @Override
    public String getAsString() {
        return "@" + this.getName() + this.getBody();
    }

    @Override
    public String getAsShortString() {
        this.touchedClassNameSet_.add(this.getName());
        return "@" + ClassUtils.getShortName((String)this.getName()) + this.getShortBody();
    }

    @Override
    public String getMetaName() {
        return this.metaName_;
    }

    @Override
    public String getBody() {
        return this.getBody0(false);
    }

    @Override
    public String getShortBody() {
        return this.getBody0(true);
    }

    protected String getBody0(boolean shorten) {
        StringBuilder sb = new StringBuilder();
        sb.append("(name = \"").append(this.metaName_).append("\"");
        if (this.metaValue_.length > 0) {
            sb.append(", value = ").append(this.toLiteral(this.metaValue_, shorten));
        }
        if (this.metaClassValue_.length > 0) {
            sb.append(", classValue = ").append(this.toLiteral(this.metaClassValue_, shorten));
        }
        sb.append(")");
        return sb.toString();
    }

    protected String toLiteral(Object[] objs, boolean shorten) {
        if (objs == null) {
            return String.valueOf(null);
        }
        if (objs.length == 1) {
            return this.toLiteral(objs[0], shorten);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String delim = "";
        for (int i = 0; i < objs.length; ++i) {
            sb.append(delim).append(this.toLiteral(objs[i], shorten));
            delim = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    protected String toLiteral(Object obj, boolean shorten) {
        if (obj == null) {
            return String.valueOf(null);
        }
        if (obj instanceof Class) {
            if (shorten) {
                this.touchedClassNameSet_.add(((Class)obj).getName());
                return ClassUtils.getShortName((Class)((Class)obj)) + ".class";
            }
            return ((Class)obj).getName() + ".class";
        }
        return StringUtils.quoteString((String)obj.toString(), (char)'\"');
    }

    @Override
    public String getName() {
        return Meta.class.getName();
    }

    @Override
    public void setBody(String body) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue(String name) {
        if (name.equals(this.metaName_) && this.metaValue_.length > 0) {
            return this.metaValue_[0];
        }
        return null;
    }

    @Override
    public boolean hasValue(String name) {
        return name.equals(this.metaName_);
    }

    @Override
    public String[] getValues(String name) {
        if (name.equals(this.metaName_)) {
            return this.metaValue_;
        }
        return null;
    }

    @Override
    public Class<?>[] getClassValues(String name) {
        if (name.equals(this.metaName_)) {
            return this.metaClassValue_;
        }
        return null;
    }

    @Override
    public void addDependingClassNamesTo(Set<String> set) {
        set.add(Meta.class.getName());
        for (Class<?> value : this.metaClassValue_) {
            set.add(value.getName());
        }
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (set == this.touchedClassNameSet_) {
            return;
        }
        this.touchedClassNameSet_ = set;
    }
}

