/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.InvalidClassDescException;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;

public class CreateTemplateAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAM_TEMPLATE = "__ymir__template";
    private static final String PARAM_TRANSITION = "__ymir__transition";
    private static final String PARAM_TRANSITIONREDIRECT = "__ymir__transition_redirect";

    public CreateTemplateAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        Template template = pathMetaData.getTemplate();
        String templateSource = "";
        if (!template.isDirectory()) {
            templateSource = this.getSourceCreator().getSourceGenerator().generateTemplateSource(this.getSuffix(template.getName()), new HashMap<String, Object>());
        } else if (pathMetaData.getSourceFile().exists()) {
            return null;
        }
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("templateSource", templateSource);
        variableMap.put("mkdirChecked", template.getName().indexOf(".") < 0);
        return this.getSourceCreator().getResponseCreator().createResponse("createTemplate", variableMap);
    }

    Response actCreate(Request request, PathMetaData pathMetaData) {
        boolean successfullySynchronized;
        HttpMethod method = this.getHttpMethod(request);
        if (method == null) {
            return null;
        }
        String templateString = request.getParameter(PARAM_TEMPLATE);
        String transition = request.getParameter(PARAM_TRANSITION);
        boolean redirect = "true".equals(request.getParameter(PARAM_TRANSITIONREDIRECT));
        if (templateString != null) {
            Template template = pathMetaData.getTemplate();
            try {
                IOUtils.writeString((OutputStream)template.getOutputStream(), (String)templateString, (String)template.getEncoding(), (boolean)false);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            successfullySynchronized = this.synchronizeResources(new String[]{this.getPath(template)});
            this.pause(1000L);
            this.openResourceInEclipseEditor(this.getPath(template));
        } else if (transition != null) {
            if (PropertyUtils.valueOf((String)request.getParameter("mkdir"), (boolean)false)) {
                pathMetaData.getTemplate().mkdirs();
            }
            DescPool pool = this.newDescPool();
            String path = pathMetaData.getPath();
            pool.setBornOf(path);
            ClassDesc classDesc = this.getSourceCreator().newClassDesc(pool, pathMetaData.getClassName(), null);
            MethodDesc actionMethodDesc = this.getSourceCreator().newActionMethodDesc(pool, path, method, new ActionSelectorSeedImpl());
            actionMethodDesc.setReturnTypeDesc((Type)((Object)String.class));
            actionMethodDesc.getReturnTypeDesc().setExplicit(true);
            if (redirect) {
                transition = "redirect:" + transition;
            }
            actionMethodDesc.setBodyDesc(new BodyDescImpl("return " + this.quote(transition.trim()) + ";", new String[0]));
            classDesc.setMethodDesc(actionMethodDesc);
            this.getSourceCreator().adjustByExistentClass(classDesc);
            try {
                this.getSourceCreator().updateClass(classDesc);
            }
            catch (InvalidClassDescException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
            successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath()});
            this.pause(1000L);
            this.openJavaCodeInEclipseEditor(pathMetaData.getClassName());
        } else {
            return null;
        }
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("templateCreatd", templateString != null);
        variableMap.put("transitionSet", transition != null);
        variableMap.put("transition", transition);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createTemplate_create", variableMap);
    }
}

