/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.seasar.ymir.AttributeContainer;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.FormFile;
import org.seasar.ymir.FrameworkRequest;
import org.seasar.ymir.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements FrameworkRequest {
    private String contextPath_;
    private HttpMethod method_;
    private String characterEncoding_;
    private Map<String, String[]> queryParameterMap_;
    private Map<String, FormFile[]> fileParameterMap_;
    private Map<String, Object> extendedParameterMap_ = Collections.emptyMap();
    private Map<String, String[]> parameterMap_;
    private AttributeContainer attributeContainer_;
    private Dispatch requestDispatch_;
    private Dispatch dispatch_;
    private LinkedList<Dispatch> dispatchStack_ = new LinkedList();

    public RequestImpl() {
    }

    public RequestImpl(String contextPath, HttpMethod method, String characterEncoding, Map<String, String[]> queryParameterMap, Map<String, FormFile[]> fileParameterMap, AttributeContainer attributeContainer) {
        this.contextPath_ = contextPath;
        this.method_ = method;
        this.characterEncoding_ = characterEncoding;
        this.setQueryParameterMap(this.safeMap(queryParameterMap));
        this.fileParameterMap_ = this.safeMap(fileParameterMap);
        this.attributeContainer_ = attributeContainer;
    }

    <K, V> Map<K, V> safeMap(Map<K, V> map) {
        return map != null ? map : new HashMap();
    }

    @Override
    public HttpMethod getMethod() {
        return this.method_;
    }

    public void setMethod(HttpMethod method) {
        this.method_ = method;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding_;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding_ = characterEncoding;
    }

    @Override
    public String getContextPath() {
        return this.contextPath_;
    }

    public void setContextPath(String contextPath) {
        this.contextPath_ = contextPath;
    }

    @Override
    public String getPath() {
        return this.requestDispatch_.getPath();
    }

    @Override
    public String getAbsolutePath() {
        return this.requestDispatch_.getAbsolutePath();
    }

    @Override
    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    @Override
    public String getParameter(String name, String defaultValue) {
        String[] values = this.parameterMap_.get(name);
        if (values != null) {
            if (values.length > 0) {
                return values[0];
            }
            return "";
        }
        return defaultValue;
    }

    @Override
    public String[] getParameterValues(String name, String[] defaultValues) {
        String[] values = this.parameterMap_.get(name);
        if (values != null) {
            return values;
        }
        return defaultValues;
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getParameterValues(name, null);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.parameterMap_.keySet().iterator();
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap_;
    }

    public void setQueryParameterMap(Map<String, String[]> queryParameterMap) {
        this.queryParameterMap_ = queryParameterMap;
        this.parameterMap_ = queryParameterMap;
    }

    @Override
    public FormFile getFileParameter(String name) {
        FormFile[] values = this.fileParameterMap_.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public FormFile[] getFileParameterValues(String name) {
        FormFile[] values = this.fileParameterMap_.get(name);
        if (values != null) {
            return values;
        }
        return null;
    }

    @Override
    public Iterator<String> getFileParameterNames() {
        return this.fileParameterMap_.keySet().iterator();
    }

    @Override
    public Map<String, FormFile[]> getFileParameterMap() {
        return this.fileParameterMap_;
    }

    @Override
    public Object getExtendedParameter(String name) {
        return this.extendedParameterMap_.get(name);
    }

    @Override
    public Object getExtendedParameter(String name, Object defaultValue) {
        Object value = this.extendedParameterMap_.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Iterator<String> getExtendedParameterNames() {
        return this.extendedParameterMap_.keySet().iterator();
    }

    @Override
    public Map<String, Object> getExtendedParameterMap() {
        return this.extendedParameterMap_;
    }

    @Override
    public void setExtendedParameterMap(Map<String, Object> extendedParameterMap) {
        this.extendedParameterMap_ = extendedParameterMap;
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.attributeContainer_;
    }

    public void setAttributeContainer(AttributeContainer attributeContainer) {
        this.attributeContainer_ = attributeContainer;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributeContainer_.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.attributeContainer_.getAttributeNames();
    }

    @Override
    public void removeAttribute(String name) {
        this.attributeContainer_.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributeContainer_.setAttribute(name, value);
    }

    @Override
    public Dispatch getRequestDispatch() {
        return this.requestDispatch_;
    }

    @Override
    public Dispatch getCurrentDispatch() {
        return this.dispatch_;
    }

    @Override
    public boolean isIncluded() {
        for (Dispatch dispatch : this.dispatchStack_) {
            if (dispatch.getDispatcher() != Dispatcher.INCLUDE) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enterDispatch(Dispatch dispatch) {
        if (this.requestDispatch_ == null) {
            this.requestDispatch_ = dispatch;
        }
        this.dispatchStack_.addFirst(dispatch);
        this.dispatch_ = dispatch;
        this.parameterMap_ = this.mergeParameterMap(this.queryParameterMap_, dispatch.getURIParameterMap());
    }

    Map<String, String[]> mergeParameterMap(Map<String, String[]> queryParameterMap, Map<String, String[]> uriParameterMap) {
        HashMap<String, String[]> merged = new HashMap<String, String[]>(queryParameterMap);
        for (Map.Entry<String, String[]> entry : uriParameterMap.entrySet()) {
            String[] newV;
            String key = entry.getKey();
            String[] value = entry.getValue();
            String[] v = (String[])merged.get(key);
            if (v == null) {
                newV = value;
            } else {
                newV = new String[v.length + value.length];
                System.arraycopy(v, 0, newV, 0, v.length);
                System.arraycopy(value, 0, newV, v.length, value.length);
            }
            merged.put(key, newV);
        }
        return merged;
    }

    @Override
    public void leaveDispatch() {
        this.parameterMap_ = this.unmergeParameterMap(this.queryParameterMap_);
        this.dispatchStack_.removeFirst();
        if (!this.dispatchStack_.isEmpty()) {
            this.dispatch_ = this.dispatchStack_.peek();
        } else {
            this.dispatch_ = null;
            this.requestDispatch_ = null;
        }
    }

    Map<String, String[]> unmergeParameterMap(Map<String, String[]> queryParameterMap) {
        return queryParameterMap;
    }

    @Override
    public String getActionName() {
        return this.dispatch_.getActionName();
    }

    @Override
    public String getOriginalActionName() {
        return this.dispatch_.getOriginalActionName();
    }
}

