/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlOutputFormat;
import org.seasar.teeda.core.render.html.HtmlOutputFormatRenderer;

public class HtmlOutputFormatRendererTest
extends RendererTest {
    private HtmlOutputFormatRenderer renderer;
    private MockHtmlOutputFormat htmlOutputFormat;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlOutputFormatRenderer();
        this.htmlOutputFormat = new MockHtmlOutputFormat();
        this.htmlOutputFormat.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlOutputFormat.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"abc", (String)this.getResponseText());
    }

    public void testEncode_NullValue() throws Exception {
        this.htmlOutputFormat.setValue(null);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlOutputFormat.setId("a");
        this.htmlOutputFormat.setValue("b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"<span id=\"a\">b</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlOutputFormat.setValue("b");
        this.htmlOutputFormat.getAttributes().put("aa", "AA");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"<span aa=\"AA\">b</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlOutputFormat.setValue("b");
        this.htmlOutputFormat.getAttributes().put("a.a", "AA");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"b", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlOutputFormat.setRendered(false);
        this.htmlOutputFormat.setId("a");
        this.htmlOutputFormat.setValue("b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithParams() throws Exception {
        this.htmlOutputFormat.setValue("1{0}2{1}3");
        UIParameter param1 = new UIParameter();
        param1.setValue((Object)"a");
        UIParameter param2 = new UIParameter();
        param2.setValue((Object)"b");
        this.htmlOutputFormat.getChildren().add(param1);
        this.htmlOutputFormat.getChildren().add(param2);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"1a2b3", (String)this.getResponseText());
    }

    public void testEncode_WithJapaneseParam() throws Exception {
        this.htmlOutputFormat.setValue("1{0}2");
        UIParameter param2 = new UIParameter();
        param2.setValue((Object)new Character('\u3042'));
        this.htmlOutputFormat.getChildren().add(param2);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)("1" + new Character('\u3042') + "2"), (String)this.getResponseText());
    }

    public void testEncode_EscapeTrue() throws Exception {
        this.htmlOutputFormat.setEscape(true);
        this.htmlOutputFormat.setValue("<a>");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"&lt;a&gt;", (String)this.getResponseText());
    }

    public void testEncode_EscapeFalse() throws Exception {
        this.htmlOutputFormat.setEscape(false);
        this.htmlOutputFormat.setValue("<a>");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        HtmlOutputFormatRendererTest.assertEquals((String)"<a>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlOutputFormat.setId("a");
        this.htmlOutputFormat.setValue("b");
        this.htmlOutputFormat.setStyle("c");
        this.htmlOutputFormat.setStyleClass("d");
        this.htmlOutputFormat.setTitle("e");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputFormat);
        Diff diff = new Diff("<span id=\"a\" style=\"c\" class=\"d\" title=\"e\">b</span>", this.getResponseText());
        HtmlOutputFormatRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetLocaleFromUIViewRoot() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.setViewRoot(new UIViewRoot());
        context.getViewRoot().setLocale(Locale.CANADA);
        HtmlOutputFormatRendererTest.assertEquals((Object)Locale.CANADA, (Object)this.renderer.getLocale((FacesContext)context));
        context.getViewRoot().setLocale(Locale.CHINESE);
        HtmlOutputFormatRendererTest.assertEquals((Object)Locale.CHINESE, (Object)this.renderer.getLocale((FacesContext)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLocaleFromDefault() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.setViewRoot(new UIViewRoot());
        context.getViewRoot().setLocale(null);
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.GERMANY);
            HtmlOutputFormatRendererTest.assertEquals((Object)Locale.GERMANY, (Object)this.renderer.getLocale((FacesContext)context));
            context.getViewRoot().setLocale(Locale.CHINESE);
            HtmlOutputFormatRendererTest.assertEquals((Object)Locale.CHINESE, (Object)this.renderer.getLocale((FacesContext)context));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    public void testGetRendersChildren() throws Exception {
        HtmlOutputFormatRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    protected MockFacesContext getFacesContext() {
        MockFacesContext context = super.getFacesContext();
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setLocale(Locale.getDefault());
        context.setViewRoot(viewRoot);
        return context;
    }

    private HtmlOutputFormatRenderer createHtmlOutputFormatRenderer() {
        return (HtmlOutputFormatRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlOutputFormatRenderer renderer = new HtmlOutputFormatRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

