/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.util.List;
import java.util.Locale;
import org.seasar.teeda.core.config.faces.element.ApplicationElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.LocaleConfigElement;
import org.seasar.teeda.core.config.faces.element.impl.ApplicationElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigImpl;
import org.seasar.teeda.core.config.faces.handler.ApplicationTagHandler;
import org.seasar.teeda.core.config.faces.handler.TagHandlerTestCase;

public class ApplicationTagHandlerTest
extends TagHandlerTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ApplicationTagHandlerTest(String arg0) {
        super(arg0);
    }

    public void testApplicationTagHandler() {
        ApplicationTagHandler handler = new ApplicationTagHandler();
        this.getContext().push((Object)new FacesConfigImpl());
        ApplicationElementImpl appElement = new ApplicationElementImpl();
        this.getContext().push((Object)appElement);
        handler.end(this.getContext(), null);
        FacesConfig facesConfig = (FacesConfig)this.getContext().pop();
        List appElements = facesConfig.getApplicationElements();
        ApplicationTagHandlerTest.assertNotNull((Object)appElements);
        ApplicationElement target = (ApplicationElement)appElements.get(0);
        ApplicationTagHandlerTest.assertTrue((boolean)(target instanceof ApplicationElement));
        ApplicationTagHandlerTest.assertEquals((Object)appElement, (Object)target);
    }

    public void testApplicationTagHandlerByXMLParse() throws Exception {
        FacesConfig facesConfig = this.parse("testApplicationTagHandler.xml");
        List list = facesConfig.getApplicationElements();
        ApplicationTagHandlerTest.assertEquals((int)1, (int)list.size());
        ApplicationElement application = (ApplicationElement)list.get(0);
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getActionListeners().size());
        ApplicationTagHandlerTest.assertEquals((Object)"a", application.getActionListeners().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getDefaultRenderKitIds().size());
        ApplicationTagHandlerTest.assertEquals((Object)"b", application.getDefaultRenderKitIds().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getLocaleConfigs().size());
        LocaleConfigElement locale = (LocaleConfigElement)application.getLocaleConfigs().get(0);
        ApplicationTagHandlerTest.assertEquals((Object)Locale.ENGLISH, (Object)locale.getDefaultLocale());
        ApplicationTagHandlerTest.assertEquals((Object)Locale.JAPANESE, locale.getSupportedLocales().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getMessageBundles().size());
        ApplicationTagHandlerTest.assertEquals((Object)"e", application.getMessageBundles().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getNavigationHandlers().size());
        ApplicationTagHandlerTest.assertEquals((Object)"f", application.getNavigationHandlers().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getPropertyResolvers().size());
        ApplicationTagHandlerTest.assertEquals((Object)"g", application.getPropertyResolvers().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getStateManagers().size());
        ApplicationTagHandlerTest.assertEquals((Object)"h", application.getStateManagers().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getVariableResolvers().size());
        ApplicationTagHandlerTest.assertEquals((Object)"i", application.getVariableResolvers().get(0));
        ApplicationTagHandlerTest.assertEquals((int)1, (int)application.getViewHandlers().size());
        ApplicationTagHandlerTest.assertEquals((Object)"j", application.getViewHandlers().get(0));
    }
}

