/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import org.seasar.teeda.core.config.faces.assembler.impl.ViewHandlerAssembler;
import org.seasar.teeda.core.mock.MockSingleConstructorViewHandler;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ViewHandlerAssemblerTest
extends TeedaTestCase {
    public ViewHandlerAssemblerTest(String name) {
        super(name);
    }

    public void testSimpleAssembleVariableResolver() throws Exception {
        String resolverName = "org.seasar.teeda.core.mock.MockViewHandlerImpl";
        ViewHandlerAssembler assembler = new ViewHandlerAssembler(resolverName, (Application)this.getApplication());
        assembler.assemble();
        ViewHandler handler = this.getApplication().getViewHandler();
        ViewHandlerAssemblerTest.assertNotNull((Object)handler);
        ViewHandlerAssemblerTest.assertTrue((boolean)(handler instanceof MockViewHandlerImpl));
    }

    public void testMarshalAssembleVariableResolver() throws Exception {
        this.getApplication().setViewHandler((ViewHandler)new MockViewHandlerImpl());
        String handlerName = "org.seasar.teeda.core.mock.MockSingleConstructorViewHandler";
        ViewHandlerAssembler assembler = new ViewHandlerAssembler(handlerName, (Application)this.getApplication());
        assembler.assemble();
        ViewHandler handler = this.getApplication().getViewHandler();
        ViewHandlerAssemblerTest.assertNotNull((Object)handler);
        ViewHandlerAssemblerTest.assertTrue((boolean)(handler instanceof MockSingleConstructorViewHandler));
        MockSingleConstructorViewHandler h = (MockSingleConstructorViewHandler)handler;
        ViewHandlerAssemblerTest.assertTrue((boolean)(h.getOriginal() instanceof MockViewHandlerImpl));
    }
}

