/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import javax.faces.FactoryFinder;
import junit.framework.TestCase;

public class FactoryFinderTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        FactoryFinder.releaseFactories();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        FactoryFinder.releaseFactories();
    }

    public void testApplicationFactory() throws Exception {
        FactoryFinderTest.assertEquals((String)"javax.faces.application.ApplicationFactory", (String)"javax.faces.application.ApplicationFactory");
    }

    public void testFacesContextFactory() throws Exception {
        FactoryFinderTest.assertEquals((String)"javax.faces.context.FacesContextFactory", (String)"javax.faces.context.FacesContextFactory");
    }

    public void testLifecycleFactory() throws Exception {
        FactoryFinderTest.assertEquals((String)"javax.faces.lifecycle.LifecycleFactory", (String)"javax.faces.lifecycle.LifecycleFactory");
    }

    public void testRenderKitFactory() throws Exception {
        FactoryFinderTest.assertEquals((String)"javax.faces.render.RenderKitFactory", (String)"javax.faces.render.RenderKitFactory");
    }

    public void testGetFactory() throws Exception {
        FactoryFinder.releaseFactories();
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"org.seasar.teeda.core.mock.MockApplicationFactory");
        Object target = FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        FactoryFinderTest.assertEquals((String)"org.seasar.teeda.core.mock.MockApplicationFactory", (String)target.getClass().getName());
    }

    public void testDuplicateSetFactory() throws Exception {
        FactoryFinder.releaseFactories();
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"org.seasar.teeda.core.mock.MockApplicationFactory");
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"org.seasar.teeda.core.mock.MockApplicationFactory2");
        Object target = FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        FactoryFinderTest.assertEquals((String)"org.seasar.teeda.core.mock.MockApplicationFactory2", (String)target.getClass().getName());
    }

    public void testNotFactoryNameGiven() {
        try {
            FactoryFinder.getFactory(null);
            FactoryFinderTest.fail();
        }
        catch (NullPointerException e) {
            FactoryFinderTest.assertTrue((boolean)true);
        }
        try {
            FactoryFinder.setFactory(null, (String)"org.seasar.teeda.core.mock.MockApplicationFactory");
            FactoryFinderTest.fail();
        }
        catch (NullPointerException e) {
            FactoryFinderTest.assertTrue((boolean)true);
        }
    }

    public void testNotSetFactory() throws Exception {
        try {
            FactoryFinder.getFactory((String)"org.seasar.teeda.core.mock.MockApplicationFactory");
            FactoryFinderTest.fail();
        }
        catch (IllegalStateException e) {
            FactoryFinderTest.assertTrue((boolean)true);
        }
    }

    public void testSetUnidentifyFatoryName() throws Exception {
        try {
            FactoryFinder.setFactory((String)((Object)((Object)this)).getClass().getName(), (String)"org.seasar.teeda.core.mock.MockApplicationFactory");
            FactoryFinderTest.fail();
        }
        catch (IllegalArgumentException e) {
            FactoryFinderTest.assertTrue((boolean)true);
        }
    }
}

