/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.teeda.core.application.impl.DefaultComponentLookupStrategy;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultComponentLookupStrategyTest
extends TeedaTestCase {
    public void testGetComponentByName_normal() throws Exception {
        this.getContainer().register(Hoge.class, "hoge1");
        DefaultComponentLookupStrategy st = new DefaultComponentLookupStrategy();
        Object o = st.getComponentByName("hoge1");
        DefaultComponentLookupStrategyTest.assertTrue((boolean)(o instanceof Hoge));
    }

    public void testGetComponentByName_getFromDefaultNamespace() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(Hoge.class, "hoge1");
        container.setNamespace("teeda");
        this.getContainer().include((S2Container)container);
        DefaultComponentLookupStrategy st = new DefaultComponentLookupStrategy();
        Object o = st.getComponentByName("hoge1");
        DefaultComponentLookupStrategyTest.assertTrue((boolean)(o instanceof Hoge));
    }

    public void testGetComponentByClass() throws Exception {
        this.getContainer().register(Hoge.class);
        DefaultComponentLookupStrategy st = new DefaultComponentLookupStrategy();
        Object o = st.getComponentByClass(Hoge.class);
        DefaultComponentLookupStrategyTest.assertTrue((boolean)(o instanceof Hoge));
    }

    public void testNamespace() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.setNamespace("aaa");
        container.register(Hoge.class);
        this.getContainer().include((S2Container)container);
        DefaultComponentLookupStrategy st = new DefaultComponentLookupStrategy();
        st.addNamespace("aaa");
        Object o = st.getComponentByClass(Hoge.class);
        DefaultComponentLookupStrategyTest.assertTrue((boolean)(o instanceof Hoge));
    }

    public static class Hoge2
    extends Hoge {
    }

    public static class Hoge {
    }
}

