/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.GZIPInputStreamUtil;

public class GZIPInputStreamUtilTest
extends TeedaTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInputStream() throws Exception {
        String path = this.convertPath("testGZIPInputStreamUtil.gz");
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        InputStream o = null;
        try {
            o = GZIPInputStreamUtil.getInputStream((InputStream)is);
            GZIPInputStreamUtilTest.assertNotNull((Object)o);
            GZIPInputStreamUtilTest.assertTrue((boolean)(o instanceof GZIPInputStream));
        }
        finally {
            is.close();
            o.close();
        }
    }

    public void testGetInputStream_throwIOException() throws Exception {
        IOExceptionOccurInputStream In = new IOExceptionOccurInputStream();
        try {
            GZIPInputStreamUtil.getInputStream((InputStream)In);
            GZIPInputStreamUtilTest.fail();
        }
        catch (IORuntimeException e) {
            GZIPInputStreamUtilTest.success();
        }
    }

    private static class IOExceptionOccurInputStream
    extends InputStream {
        private IOExceptionOccurInputStream() {
        }

        public int read() throws IOException {
            throw new IOException();
        }
    }
}

