/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Date;
import junit.framework.TestCase;
import org.seasar.teeda.core.util.ConverterUtil;

public class ConverterUtilTest
extends TestCase {
    public void testConvertToInt() throws Exception {
        ConverterUtilTest.assertEquals((int)20, (int)ConverterUtil.convertToInt((Object)new Integer(20)));
        ConverterUtilTest.assertEquals((int)10, (int)ConverterUtil.convertToInt((Object)"10"));
        boolean goException = false;
        try {
            ConverterUtil.convertToInt((Object)"hoge");
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
        goException = false;
        try {
            ConverterUtil.convertToInt((Object)new Boolean(false));
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
    }

    public void testConvertToBoolean() throws Exception {
        ConverterUtilTest.assertTrue((boolean)ConverterUtil.convertToBoolean((Object)new Boolean(true)));
        ConverterUtilTest.assertFalse((boolean)ConverterUtil.convertToBoolean((Object)"false"));
        boolean goException = false;
        try {
            ConverterUtil.convertToBoolean((Object)new Date());
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
    }

    public void testConvertToLong() throws Exception {
        ConverterUtilTest.assertEquals((long)8888888888L, (long)ConverterUtil.convertToLong((Object)new Long(8888888888L)));
        ConverterUtilTest.assertEquals((long)9999999999L, (long)ConverterUtil.convertToLong((Object)"9999999999"));
        boolean goException = false;
        try {
            ConverterUtil.convertToLong((Object)"hoge");
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
        goException = false;
        try {
            ConverterUtil.convertToLong((Object)new Boolean(false));
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
    }

    public void testConvertToDouble() throws Exception {
        ConverterUtilTest.assertTrue((1.0 == ConverterUtil.convertToDouble((Object)new Double(1.0)) ? 1 : 0) != 0);
        ConverterUtilTest.assertTrue((2.0 == ConverterUtil.convertToDouble((Object)"2") ? 1 : 0) != 0);
        boolean goException = false;
        try {
            ConverterUtil.convertToDouble((Object)"hoge");
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
        goException = false;
        try {
            ConverterUtil.convertToDouble((Object)new Boolean(false));
        }
        catch (IllegalArgumentException e) {
            goException = true;
            System.out.println(e.getMessage());
        }
        ConverterUtilTest.assertTrue((boolean)goException);
    }
}

