/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectOneRadio;
import org.seasar.teeda.core.render.html.HtmlSelectOneRadioRenderer;

public class HtmlSelectOneRadioRendererTest
extends RendererTest {
    private HtmlSelectOneRadioRenderer renderer;
    private MockHtmlSelectOneRadio htmlSelectOneRadio;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectOneRadioRenderer();
        this.htmlSelectOneRadio = new MockHtmlSelectOneRadio();
        this.htmlSelectOneRadio.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectOneRadio.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.htmlSelectOneRadio.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"radio\" name=\"a\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.htmlSelectOneRadio.setId("a");
        this.htmlSelectOneRadio.getAttributes().put("z", "x");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"radio\" name=\"a\" value=\"val\" z=\"x\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.htmlSelectOneRadio.setId("a");
        this.htmlSelectOneRadio.getAttributes().put(".", "x");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table id=\"a\"><tr><td><label><input type=\"radio\" name=\"a\" value=\"val\" />lab</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Children_PageDirection() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.htmlSelectOneRadio.setLayout("pageDirection");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td></tr><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Checked() throws Exception {
        this.htmlSelectOneRadio.setValue("v2");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" checked=\"checked\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" disabled=\"disabled\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectOneRadio.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" disabled=\"disabled\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectOneRadio.setEnabledClass("ec");
        this.htmlSelectOneRadio.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label class=\"ec\"><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label class=\"dc\"><input type=\"radio\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectOneRadio.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Optgroup() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((String)"<table><tr><td><table><tr><td><label><input type=\"radio\" name=\"_id0\" value=\"v1\" />l1</label></td><td><label><input type=\"radio\" name=\"_id0\" value=\"v2\" disabled=\"disabled\" />l2</label></td></tr></table></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlSelectOneRadio.setAccesskey("a");
        this.htmlSelectOneRadio.setBorder(3);
        this.htmlSelectOneRadio.setDir("b");
        this.htmlSelectOneRadio.setDisabled(true);
        this.htmlSelectOneRadio.setDisabledClass("d");
        this.htmlSelectOneRadio.setEnabledClass("e");
        this.htmlSelectOneRadio.setLang("f");
        this.htmlSelectOneRadio.setOnblur("g");
        this.htmlSelectOneRadio.setOnchange("h");
        this.htmlSelectOneRadio.setOnclick("i");
        this.htmlSelectOneRadio.setOndblclick("j");
        this.htmlSelectOneRadio.setOnfocus("k");
        this.htmlSelectOneRadio.setOnkeydown("l");
        this.htmlSelectOneRadio.setOnkeypress("m");
        this.htmlSelectOneRadio.setOnkeyup("n");
        this.htmlSelectOneRadio.setOnmousedown("o");
        this.htmlSelectOneRadio.setOnmousemove("p");
        this.htmlSelectOneRadio.setOnmouseout("q");
        this.htmlSelectOneRadio.setOnmouseover("r");
        this.htmlSelectOneRadio.setOnmouseup("s");
        this.htmlSelectOneRadio.setOnselect("t");
        this.htmlSelectOneRadio.setReadonly(true);
        this.htmlSelectOneRadio.setStyle("w");
        this.htmlSelectOneRadio.setStyleClass("u");
        this.htmlSelectOneRadio.setTabindex("x");
        this.htmlSelectOneRadio.setTitle("y");
        this.htmlSelectOneRadio.getAttributes().put("name", "foo");
        this.htmlSelectOneRadio.getAttributes().put("type", "radio");
        this.htmlSelectOneRadio.getAttributes().put("checked", "checked");
        this.htmlSelectOneRadio.setId("A");
        this.htmlSelectOneRadio.setValue("val");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneRadio.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneRadio);
        Diff diff = new Diff("<table id=\"A\" border=\"3\" style=\"w\" class=\"u\"><tr><td><label class=\"d\"><input type=\"radio\" name=\"A\" value=\"val\" checked=\"checked\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"/>lab</label></td></tr></table>", this.getResponseText());
        HtmlSelectOneRadioRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectOneRadio.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((int)0, (int)this.htmlSelectOneRadio.getSetSubmittedValueCalls());
        HtmlSelectOneRadioRendererTest.assertEquals(null, (Object)this.htmlSelectOneRadio.getSubmittedValue());
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectOneRadio.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        MockHttpServletRequest mockHttpServletRequest = context.getMockExternalContext().getMockHttpServletRequest();
        mockHttpServletRequest.addParameter("keyA", "a");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneRadio);
        HtmlSelectOneRadioRendererTest.assertEquals((int)1, (int)this.htmlSelectOneRadio.getSetSubmittedValueCalls());
        HtmlSelectOneRadioRendererTest.assertEquals((Object)"a", (Object)this.htmlSelectOneRadio.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectOneRadioRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    public void testGetConvertedValue() throws Exception {
        try {
            this.htmlSelectOneRadio.setConverter((Converter)new IntegerConverter());
            Object o = this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)this.htmlSelectOneRadio, (Object)"2");
            HtmlSelectOneRadioRendererTest.assertNotNull((Object)o);
            Integer i = (Integer)o;
            HtmlSelectOneRadioRendererTest.assertTrue((i == 2 ? 1 : 0) != 0);
            HtmlSelectOneRadioRendererTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException e) {
            HtmlSelectOneRadioRendererTest.fail();
        }
    }

    private HtmlSelectOneRadioRenderer createHtmlSelectOneRadioRenderer() {
        return (HtmlSelectOneRadioRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectOneRadioRenderer renderer = new HtmlSelectOneRadioRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

