/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.SerializableStateHolder;
import javax.faces.render.ResponseStateManager;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.application.TreeStructureManager;
import org.seasar.teeda.core.application.impl.TeedaStateManagerImpl;
import org.seasar.teeda.core.application.impl.TreeStructureManagerImpl;
import org.seasar.teeda.core.mock.MockRenderKit;
import org.seasar.teeda.core.mock.MockResponseStateManagerImpl;
import org.seasar.teeda.core.mock.MockUIViewRoot;
import org.seasar.teeda.core.mock.NullResponseStateManager;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class TeedaStateManagerImplTest
extends TeedaTestCase {
    public void testRestoreView() throws Exception {
    }

    public void testRestoreView_renderKitIdNull() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        try {
            manager.restoreView((FacesContext)this.getFacesContext(), "a", null);
            TeedaStateManagerImplTest.fail();
        }
        catch (IllegalArgumentException expected) {
            TeedaStateManagerImplTest.success();
        }
    }

    public void testRestoreView_getFromServer() throws Exception {
        this.getServletContext().setInitParameter("javax.faces.STATE_SAVING_METHOD", "server");
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        MockUIViewRoot root = new MockUIViewRoot();
        root.setId("aaa");
        root.setRenderKitId("renderKitId");
        root.setViewId("viewId");
        root.setLocale(Locale.JAPAN);
        this.getFacesContext().setViewRoot((UIViewRoot)root);
        manager.setTreeStructureManager((TreeStructureManager)new TreeStructureManagerImpl());
        manager.saveSerializedView((FacesContext)this.getFacesContext());
        UIViewRoot r = manager.restoreView((FacesContext)this.getFacesContext(), "viewId", "HTML_BASIC");
        TeedaStateManagerImplTest.assertNotNull((Object)r);
        TeedaStateManagerImplTest.assertTrue((boolean)(r instanceof MockUIViewRoot));
        TeedaStateManagerImplTest.assertEquals((String)"aaa", (String)r.getId());
        TeedaStateManagerImplTest.assertEquals((String)"renderKitId", (String)r.getRenderKitId());
        TeedaStateManagerImplTest.assertEquals((String)"viewId", (String)r.getViewId());
        TeedaStateManagerImplTest.assertEquals((Object)Locale.JAPAN, (Object)r.getLocale());
        TeedaStateManagerImplTest.assertNotNull((Object)manager.getSerializedViewFromServer("viewId"));
    }

    public void testRestoreView_getFromClient() throws Exception {
        MockUIViewRoot root = new MockUIViewRoot();
        root.setId("hoge");
        root.setViewId("foo");
        root.setRenderKitId("bar");
        TreeStructure struct = new TreeStructure(((Object)((Object)root)).getClass().getName(), root.getId());
        MockResponseStateManagerImpl responseStateManager = new MockResponseStateManagerImpl();
        responseStateManager.setTreeStructureToRestore(struct);
        responseStateManager.setComponentStateToRestore((Object)"state");
        this.getRenderKit().setResponseStateManager((ResponseStateManager)responseStateManager);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        TreeStructureManagerImpl structManager = new TreeStructureManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)structManager);
        this.getFacesContext().setViewRoot((UIViewRoot)root);
        manager.saveSerializedView((FacesContext)this.getFacesContext());
        UIViewRoot r = manager.restoreView((FacesContext)this.getFacesContext(), "foo", "HTML_BASIC");
        TeedaStateManagerImplTest.assertNotNull((Object)r);
        TeedaStateManagerImplTest.assertTrue((boolean)(r instanceof MockUIViewRoot));
        TeedaStateManagerImplTest.assertEquals((String)"hoge", (String)r.getId());
        TeedaStateManagerImplTest.assertEquals((String)"foo", (String)r.getViewId());
        TeedaStateManagerImplTest.assertEquals((String)"bar", (String)r.getRenderKitId());
    }

    public void testSaveSerializedView_whenSavingStateClient() throws Exception {
        this.getServletContext().setInitParameter("javax.faces.STATE_SAVING_METHOD", "client");
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        MockUIViewRoot root = new MockUIViewRoot();
        root.setId("aaa");
        root.setRenderKitId("renderKitId");
        root.setViewId("viewId");
        root.setLocale(Locale.JAPAN);
        this.getFacesContext().setViewRoot((UIViewRoot)root);
        manager.setTreeStructureManager((TreeStructureManager)new TreeStructureManagerImpl());
        StateManager.SerializedView serView = manager.saveSerializedView((FacesContext)this.getFacesContext());
        SerializableStateHolder holder = (SerializableStateHolder)serView.getState();
        Object[] states = (Object[])holder.getState();
        TeedaStateManagerImplTest.assertEquals((Object)root.getRenderKitId(), (Object)states[1]);
        TeedaStateManagerImplTest.assertEquals((Object)root.getViewId(), (Object)states[2]);
        TreeStructure struct = (TreeStructure)serView.getStructure();
        TeedaStateManagerImplTest.assertEquals((String)((Object)((Object)root)).getClass().getName(), (String)struct.getComponentClassName());
        TeedaStateManagerImplTest.assertEquals((String)root.getId(), (String)struct.getComponentId());
    }

    public void testSaveSerializedView_whenSavingStateServer() throws Exception {
        this.getServletContext().setInitParameter("javax.faces.STATE_SAVING_METHOD", "server");
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        MockUIViewRoot root = new MockUIViewRoot();
        root.setId("aaa");
        root.setRenderKitId("renderKitId");
        root.setViewId("viewId");
        root.setLocale(Locale.JAPAN);
        this.getFacesContext().setViewRoot((UIViewRoot)root);
        manager.setTreeStructureManager((TreeStructureManager)new TreeStructureManagerImpl());
        TeedaStateManagerImplTest.assertNull((Object)manager.saveSerializedView((FacesContext)this.getFacesContext()));
        StateManager.SerializedView serView = manager.getSerializedViewFromServer("viewId");
        SerializableStateHolder holder = (SerializableStateHolder)serView.getState();
        Object[] states = (Object[])holder.getState();
        TeedaStateManagerImplTest.assertEquals((Object)root.getRenderKitId(), (Object)states[1]);
        TeedaStateManagerImplTest.assertEquals((Object)root.getViewId(), (Object)states[2]);
        TreeStructure struct = (TreeStructure)serView.getStructure();
        TeedaStateManagerImplTest.assertEquals((String)((Object)((Object)root)).getClass().getName(), (String)struct.getComponentClassName());
        TeedaStateManagerImplTest.assertEquals((String)root.getId(), (String)struct.getComponentId());
    }

    public void testGetComponentStateToSave_success() throws Exception {
        UIViewRoot root = new UIViewRoot();
        root.setId("aaa");
        this.getFacesContext().setViewRoot(root);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        Object o = manager.getComponentStateToSave((FacesContext)this.getFacesContext());
        TeedaStateManagerImplTest.assertNotNull((Object)o);
        TeedaStateManagerImplTest.assertTrue((boolean)(o instanceof SerializableStateHolder));
    }

    public void testGetComponentStateToSave_viewRootIsTransient() throws Exception {
        NotifyUIViewRoot root = new NotifyUIViewRoot(){

            public boolean isTransient() {
                return true;
            }
        };
        UIViewRoot orgRoot = this.getFacesContext().getViewRoot();
        this.getFacesContext().setViewRoot((UIViewRoot)root);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        TeedaStateManagerImplTest.assertNull((Object)manager.getComponentStateToSave((FacesContext)this.getFacesContext()));
        this.getFacesContext().setViewRoot(orgRoot);
    }

    public void testGetTreeStructureToSave_success() throws Exception {
        UIViewRoot root = new UIViewRoot();
        root.setId("aaa");
        this.getFacesContext().setViewRoot(root);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)new TreeStructureManagerImpl());
        Object o = manager.getTreeStructureToSave((FacesContext)this.getFacesContext());
        TeedaStateManagerImplTest.assertNotNull((Object)o);
        TeedaStateManagerImplTest.assertTrue((boolean)(o instanceof TreeStructure));
        TreeStructure struct = (TreeStructure)o;
        TeedaStateManagerImplTest.assertEquals((String)"aaa", (String)struct.getComponentId());
        TeedaStateManagerImplTest.assertEquals((String)root.getClass().getName(), (String)struct.getComponentClassName());
    }

    public void testGetTreeStructureToSave_viewRootIsTransient() throws Exception {
        UIViewRoot root = new UIViewRoot(){

            public boolean isTransient() {
                return true;
            }
        };
        UIViewRoot orgRoot = this.getFacesContext().getViewRoot();
        this.getFacesContext().setViewRoot(root);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)new TreeStructureManagerImpl());
        TeedaStateManagerImplTest.assertNull((Object)manager.getTreeStructureToSave((FacesContext)this.getFacesContext()));
        this.getFacesContext().setViewRoot(orgRoot);
    }

    public void testRestoreComponentStateFromClient_serializedViewIsNull() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        try {
            manager.restoreComponentState((FacesContext)this.getFacesContext(), new UIViewRoot(), null);
            TeedaStateManagerImplTest.fail();
        }
        catch (IllegalArgumentException expected) {
            TeedaStateManagerImplTest.success();
        }
    }

    public void testRestoreComponentStateFromClient_success() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        NotifyUIViewRoot component = new NotifyUIViewRoot();
        MockResponseStateManagerImpl responseStateManager = new MockResponseStateManagerImpl();
        responseStateManager.setComponentStateToRestore((Object)"state");
        this.getRenderKit().setResponseStateManager((ResponseStateManager)responseStateManager);
        manager.restoreComponentStateFromClient((FacesContext)this.getFacesContext(), (UIViewRoot)component, "HTML_BASIC");
        TeedaStateManagerImplTest.assertEquals((int)1, (int)component.getNotifyCount());
    }

    public void testRestoreComponentStateFromServer_succeed() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        NotifyUIViewRoot component = new NotifyUIViewRoot();
        component.setViewId("id");
        TreeStructure struct = new TreeStructure(((Object)((Object)component)).getClass().getName(), component.getId());
        TeedaStateManagerImpl teedaStateManagerImpl = manager;
        teedaStateManagerImpl.getClass();
        StateManager.SerializedView view = new StateManager.SerializedView((StateManager)teedaStateManagerImpl, (Object)struct, (Object)"id");
        manager.saveSerializedViewToServer("id", view);
        manager.restoreComponentStateFromServer((FacesContext)this.getFacesContext(), (UIViewRoot)component);
        TeedaStateManagerImplTest.assertEquals((int)1, (int)component.getNotifyCount());
    }

    public void testRestoreComponentStateFromServer_stateIsNull() throws Exception {
        NotifyUIViewRoot component = new NotifyUIViewRoot();
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        component.setId("id");
        TreeStructure struct = new TreeStructure(((Object)((Object)component)).getClass().getName(), component.getId());
        TeedaStateManagerImpl teedaStateManagerImpl = manager;
        teedaStateManagerImpl.getClass();
        StateManager.SerializedView view = new StateManager.SerializedView((StateManager)teedaStateManagerImpl, (Object)struct, null);
        manager.saveSerializedViewToServer("id", view);
        manager.restoreComponentStateFromServer((FacesContext)this.getFacesContext(), (UIViewRoot)component);
        TeedaStateManagerImplTest.assertEquals((int)0, (int)component.getNotifyCount());
    }

    public void testRestoreComponenentStateFromServer_serializedViewIsNull() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        NotifyUIViewRoot root = new NotifyUIViewRoot();
        manager.restoreComponentStateFromServer((FacesContext)this.getFacesContext(), (UIViewRoot)root);
        TeedaStateManagerImplTest.assertEquals((int)0, (int)root.getNotifyCount());
    }

    public void testRestoreTreeStructure_renderKitIdNull() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        try {
            manager.restoreTreeStructure((FacesContext)this.getFacesContext(), "id", null);
            TeedaStateManagerImplTest.fail();
        }
        catch (IllegalArgumentException expected) {
            TeedaStateManagerImplTest.success();
        }
    }

    public void testRestoreTreeStructureFromClient_restoredStructureIsNull() throws Exception {
        MockRenderKit renderKit = this.getRenderKit();
        renderKit.setResponseStateManager((ResponseStateManager)new NullResponseStateManager());
        this.setRenderKit(renderKit);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        TeedaStateManagerImplTest.assertNull((Object)manager.restoreTreeStructureFromClient((FacesContext)this.getFacesContext(), "id", "HTML_BASIC"));
    }

    public void testRestoreTreeStructureFromClient_restoreSucceess() throws Exception {
        MockUIViewRoot root = new MockUIViewRoot();
        root.setId("hoge");
        TreeStructure struct = new TreeStructure(((Object)((Object)root)).getClass().getName(), root.getId());
        MockResponseStateManagerImpl responseStateManager = new MockResponseStateManagerImpl();
        responseStateManager.setTreeStructureToRestore(struct);
        this.getRenderKit().setResponseStateManager((ResponseStateManager)responseStateManager);
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        TreeStructureManagerImpl structManager = new TreeStructureManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)structManager);
        UIViewRoot returnRoot = manager.restoreTreeStructureFromClient((FacesContext)this.getFacesContext(), "hoge", "HTML_BASIC");
        TeedaStateManagerImplTest.assertNotNull((Object)returnRoot);
        TeedaStateManagerImplTest.assertEquals((String)"hoge", (String)returnRoot.getId());
        TeedaStateManagerImplTest.assertTrue((boolean)(returnRoot instanceof MockUIViewRoot));
    }

    public void testRestoreTreeStructureFromServer_serializedViewIsNull() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        TreeStructureManagerImpl structManager = new TreeStructureManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)structManager);
        TeedaStateManagerImplTest.assertNull((Object)manager.restoreTreeStructureFromServer((FacesContext)this.getFacesContext(), "id"));
    }

    public void testRestoreTreeStructureFromServer_restoreSuccess() throws Exception {
        TeedaStateManagerImpl manager = new TeedaStateManagerImpl();
        UIViewRoot component = new UIViewRoot();
        component.setId("root");
        TreeStructure struct = new TreeStructure(component.getClass().getName(), component.getId());
        TeedaStateManagerImpl teedaStateManagerImpl = manager;
        teedaStateManagerImpl.getClass();
        StateManager.SerializedView view = new StateManager.SerializedView((StateManager)teedaStateManagerImpl, (Object)struct, (Object)"state");
        manager.saveSerializedViewToServer("id", view);
        TreeStructureManagerImpl structManager = new TreeStructureManagerImpl();
        manager.setTreeStructureManager((TreeStructureManager)structManager);
        UIViewRoot root = manager.restoreTreeStructureFromServer((FacesContext)this.getFacesContext(), "id");
        TeedaStateManagerImplTest.assertNotNull((Object)root);
        TeedaStateManagerImplTest.assertEquals((String)"root", (String)root.getId());
    }

    public static class NotifyUIViewRoot
    extends UIViewRoot {
        private int count = 0;

        public void processRestoreState(FacesContext context, Object state) {
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }

        public int getNotifyCount() {
            return this.count;
        }
    }
}

