/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DoubleConverter;
import javax.faces.convert.NumberConverter;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ConverterResource;
import junitx.framework.ArrayAssert;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullFacesContext;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class ValueHolderUtilTest
extends TeedaTestCase {
    public void testGetValueForRender_EditableValueHolder() throws Exception {
        UIInput editableValueHolder = new UIInput();
        ObjectAssert.assertInstanceOf((Class)EditableValueHolder.class, (Object)editableValueHolder);
        NullFacesContext context = new NullFacesContext();
        editableValueHolder.setValueBinding("value", (ValueBinding)new MockValueBinding(){

            public String getExpressionString() {
                return "#{hoge}";
            }
        });
        ValueHolderUtilTest.assertEquals((String)"", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
        editableValueHolder.setValue((Object)"asdf");
        ValueHolderUtilTest.assertEquals((String)"asdf", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
        editableValueHolder.setSubmittedValue((Object)"bbbb");
        ValueHolderUtilTest.assertEquals((String)"bbbb", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
    }

    public void testGetValueForRender_ValueHolder() throws Exception {
        UIOutput valueHolder = new UIOutput();
        ObjectAssert.assertNotInstanceOf((Class)EditableValueHolder.class, (Object)valueHolder);
        ObjectAssert.assertInstanceOf((Class)ValueHolder.class, (Object)valueHolder);
        valueHolder.setValueBinding("value", (ValueBinding)new MockValueBinding(){

            public String getExpressionString() {
                return "#{hoge}";
            }
        });
        NullFacesContext context = new NullFacesContext();
        ValueHolderUtilTest.assertEquals((String)"", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)valueHolder));
        valueHolder.setValue((Object)"abc");
        ValueHolderUtilTest.assertEquals((String)"abc", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)valueHolder));
    }

    public void testGetValueForRender_getFromConverterResource() throws Exception {
        UIInput editableValueHolder = new UIInput();
        ObjectAssert.assertInstanceOf((Class)EditableValueHolder.class, (Object)editableValueHolder);
        NullFacesContext context = new NullFacesContext();
        editableValueHolder.setValueBinding("value", (ValueBinding)new MockValueBinding(){

            public String getExpressionString() {
                return "#{hoge}";
            }
        });
        this.register(NumberConverter.class, "numberConverter");
        ConverterResource.addConverter((String)"#{hoge}", (String)"numberConverter");
        editableValueHolder.setConverter((Converter)new DoubleConverter());
        ValueHolderUtilTest.assertEquals((String)"", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
        editableValueHolder.setValue((Object)"123.12");
        ValueHolderUtilTest.assertEquals((String)"123.12", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
        editableValueHolder.setSubmittedValue((Object)"bbbb");
        ValueHolderUtilTest.assertEquals((String)"bbbb", (String)ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)editableValueHolder));
    }

    public void testGetValueForRender_NotValueHolder() throws Exception {
        UIColumn notValueHolder = new UIColumn();
        ObjectAssert.assertNotInstanceOf((Class)ValueHolder.class, (Object)notValueHolder);
        NullFacesContext context = new NullFacesContext();
        try {
            ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)notValueHolder);
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testGetValuesForRender_EditableValueHolder_Value() throws Exception {
        NullFacesContext context = new NullFacesContext();
        UISelectMany evh = new UISelectMany();
        ObjectAssert.assertInstanceOf((Class)EditableValueHolder.class, (Object)evh);
        Object[] values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[0], (Object[])values);
        evh = new UISelectMany();
        evh.setValue((Object)new String[]{"a"});
        values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"a"}, (Object[])values);
        evh = new UISelectMany();
        evh.setValue((Object)new Object[]{"a"});
        values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"a"}, (Object[])values);
        evh = new UISelectMany();
        evh.setValue((Object)new Object[]{"b", "c"});
        values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"b", "c"}, (Object[])values);
    }

    public void testGetValuesForRender_EditableValueHolder_SubmittedValue() throws Exception {
        NullFacesContext context = new NullFacesContext();
        UISelectMany evh = new UISelectMany();
        evh.setSubmittedValue((Object)new String[]{"a"});
        Object[] values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"a"}, (Object[])values);
        evh = new UISelectMany();
        evh.setSubmittedValue((Object)new String[]{"a"});
        values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"a"}, (Object[])values);
        evh = new UISelectMany();
        evh.setSubmittedValue((Object)new String[]{"b", "c"});
        values = ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)evh);
        ArrayAssert.assertEquals((Object[])new String[]{"b", "c"}, (Object[])values);
    }

    public void testGetValuesForRender_NotValueHolder() throws Exception {
        UIColumn notValueHolder = new UIColumn();
        ObjectAssert.assertNotInstanceOf((Class)ValueHolder.class, (Object)notValueHolder);
        NullFacesContext context = new NullFacesContext();
        try {
            ValueHolderUtil.getValuesForRender((FacesContext)context, (UIComponent)notValueHolder);
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }
}

