/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ObjectInputStreamUtil;

public class ObjectInputStreamUtilTest
extends TeedaTestCase {
    public void testGetObject_Deserialize() throws Exception {
        String path = this.convertPath("testObjectInputStreamUtil.ser");
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        ObjectInputStream i = ObjectInputStreamUtil.getInputStream((InputStream)is);
        Object o = i.readObject();
        ObjectInputStreamUtilTest.assertNotNull((Object)o);
        i.close();
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject_IO_fail() throws Exception {
        IOExceptionOccurInputStream is = new IOExceptionOccurInputStream();
        try {
            ObjectInputStreamUtil.getInputStream((InputStream)is);
            ObjectInputStreamUtilTest.fail();
        }
        catch (IORuntimeException e) {
            ObjectInputStreamUtilTest.success();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static class IOExceptionOccurInputStream
    extends InputStream {
        private IOExceptionOccurInputStream() {
        }

        public int available() throws IOException {
            return super.available();
        }

        public void close() throws IOException {
            super.close();
        }

        public synchronized void mark(int arg0) {
            super.mark(arg0);
        }

        public boolean markSupported() {
            return super.markSupported();
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            throw new IOException();
        }

        public int read(byte[] arg0) throws IOException {
            throw new IOException();
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public long skip(long arg0) throws IOException {
            return super.skip(arg0);
        }

        public int read() throws IOException {
            throw new IOException();
        }
    }

    public static class Hoge
    implements Serializable {
        private static final long serialVersionUID = -4246979749871499855L;
        private String name_;

        public void setName(String name) {
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }
    }
}

