/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.HTMLEncodeUtil;

public class HTMLEncodeUtilTest
extends TeedaTestCase {
    public void testEncode_amp() throws Exception {
        HTMLEncodeUtilTest.assertEquals((String)"&nbsp;", (String)HTMLEncodeUtil.encode((String)"&nbsp;", (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&amp;nbsp;", (String)HTMLEncodeUtil.encode((String)"&nbsp;", (boolean)true, (boolean)true));
    }

    public void testEncode_quote() throws Exception {
        HTMLEncodeUtilTest.assertEquals((String)"'hoge'", (String)HTMLEncodeUtil.encode((String)"'hoge'", (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&#39;hoge&#39;", (String)HTMLEncodeUtil.encode((String)"'hoge'", (boolean)true, (boolean)true));
    }

    public void testEncode_lt() throws Exception {
        HTMLEncodeUtilTest.assertEquals((String)"&lt;&lt;", (String)HTMLEncodeUtil.encode((String)"<<", (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&lt;&lt;", (String)HTMLEncodeUtil.encode((String)"<<", (boolean)true, (boolean)true));
    }

    public void testEncode_gt() throws Exception {
        HTMLEncodeUtilTest.assertEquals((String)"&gt;&gt;", (String)HTMLEncodeUtil.encode((String)">>", (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&gt;&gt;", (String)HTMLEncodeUtil.encode((String)">>", (boolean)true, (boolean)true));
    }

    public void testEncode_00A5_withDefaultStrategy() throws Exception {
        char c = '\u00a5';
        HTMLEncodeUtilTest.assertEquals((String)"&yen;", (String)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&yen;", (String)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)true, (boolean)true));
        c = '\\';
        HTMLEncodeUtilTest.assertNotSame((Object)"&yen;", (Object)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertNotSame((Object)"&yen;", (Object)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)true, (boolean)true));
        HTMLEncodeUtilTest.assertEquals((String)"\\", (String)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"\\", (String)HTMLEncodeUtil.encode((String)Character.toString(c), (boolean)true, (boolean)true));
    }

    public void testEncode_yen_for_SeasarUser5976() throws Exception {
        HTMLEncodeUtil.HtmlEncodeStrategy orgStrategy = HTMLEncodeUtil.getHtmlEncodeStrategy();
        HTMLEncodeUtil.setHtmlEncodeStrategy((HTMLEncodeUtil.HtmlEncodeStrategy)new HTMLEncodeUtil.JapaneseHtmlEncodeStrategy());
        HTMLEncodeUtilTest.assertEquals((String)"&yen;&yen;", (String)HTMLEncodeUtil.encode((String)"\\\\", (boolean)false, (boolean)false));
        HTMLEncodeUtilTest.assertEquals((String)"&yen;&yen;", (String)HTMLEncodeUtil.encode((String)"\\\\", (boolean)true, (boolean)true));
        HTMLEncodeUtil.setHtmlEncodeStrategy((HTMLEncodeUtil.HtmlEncodeStrategy)orgStrategy);
    }
}

