/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.taglib.core.ValidateLengthTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ValidateLengthTagTest
extends TeedaTestCase {
    public void testCreateValidator() throws Exception {
        String validatorId = "javax.faces.Length";
        String validatorClassName = "javax.faces.validator.LengthValidator";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator(validatorId, validatorClassName);
        this.setApplication((MockApplication)app);
        ValidateLengthTag tag = new ValidateLengthTag();
        Validator validator = tag.createValidator();
        ValidateLengthTagTest.assertNotNull((Object)validator);
        ValidateLengthTagTest.assertTrue((boolean)(validator instanceof LengthValidator));
    }

    public void testCreateValidator_NotAddValidator() throws Exception {
        ValidateLengthTag tag = new ValidateLengthTag();
        try {
            tag.createValidator();
            ValidateLengthTagTest.fail();
        }
        catch (NullPointerException e) {
            ValidateLengthTagTest.success();
        }
    }

    public void testCreateValidator_noSetProperty() throws Exception {
        this.addValidator();
        ValidateLengthTag tag = new ValidateLengthTag();
        tag.createValidator();
        ValidateLengthTagTest.assertFalse((boolean)tag.isMinimumSet());
        ValidateLengthTagTest.assertFalse((boolean)tag.isMaximumSet());
    }

    public void testSetMinimum_constantValue() throws Exception {
        this.addValidator();
        ValidateLengthTag tag = new ValidateLengthTag();
        tag.setMinimum("2");
        LengthValidator validator = (LengthValidator)tag.createValidator();
        ValidateLengthTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateLengthTagTest.assertTrue((2 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMinimum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(1));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateLengthTag tag = new ValidateLengthTag();
        tag.setMinimum("#{hoge.minimum}");
        LengthValidator validator = (LengthValidator)tag.createValidator();
        ValidateLengthTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateLengthTagTest.assertTrue((1 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_constantValue() throws Exception {
        this.addValidator();
        ValidateLengthTag tag = new ValidateLengthTag();
        tag.setMaximum("30");
        LengthValidator validator = (LengthValidator)tag.createValidator();
        ValidateLengthTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateLengthTagTest.assertTrue((30 == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(50));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateLengthTag tag = new ValidateLengthTag();
        tag.setMaximum("#{hoge.maximum}");
        LengthValidator validator = (LengthValidator)tag.createValidator();
        ValidateLengthTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateLengthTagTest.assertTrue((50 == validator.getMaximum() ? 1 : 0) != 0);
    }

    private void addValidator() throws Exception {
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator("javax.faces.Length", "javax.faces.validator.LengthValidator");
        this.setApplication((MockApplication)app);
    }
}

