/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.taglib.core.LoadBundleTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class LoadBundleTagTest
extends TeedaTestCase {
    public LoadBundleTagTest(String name) {
        super(name);
    }

    public void testLoadBundle() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.setDefaultLocale(Locale.JAPAN);
        this.getFacesContext().setApplication((Application)mockApp);
        LoadBundleTag tag = new LoadBundleTag();
        tag.setBasename("org.seasar.teeda.core.taglib.core.TestMessages");
        tag.setVar("messages");
        tag.doStartTag();
        LoadBundleTagTest.assertEquals(((Map)this.getFacesContext().getExternalContext().getRequestMap().get("messages")).get("aaa"), (Object)"AAA");
        LoadBundleTagTest.assertEquals(((Map)this.getFacesContext().getExternalContext().getRequestMap().get("messages")).get("bbb"), (Object)"BBB");
        LoadBundleTagTest.assertEquals(((Map)this.getFacesContext().getExternalContext().getRequestMap().get("messages")).get("xxx"), (Object)"???xxx???");
    }

    public void testLoadBndle_setBadBaseName() throws Exception {
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.setDefaultLocale(Locale.JAPAN);
        this.getFacesContext().setApplication((Application)mockApp);
        LoadBundleTag tag = new LoadBundleTag();
        tag.setBasename("hogehoge");
        LoadBundleTagTest.assertEquals((int)0, (int)tag.doStartTag());
    }

    public void testLoadBundleMap() throws Exception {
        boolean gotException = false;
        String key = "aaa";
        String value = "AAA";
        MockApplicationImpl mockApp = new MockApplicationImpl();
        mockApp.setDefaultLocale(Locale.JAPAN);
        this.getFacesContext().setApplication((Application)mockApp);
        LoadBundleTag tag = new LoadBundleTag();
        tag.setBasename("org.seasar.teeda.core.taglib.core.TestMessages");
        tag.setVar("messages");
        tag.doStartTag();
        Map testMap = (Map)this.getFacesContext().getExternalContext().getRequestMap().get("messages");
        LoadBundleTag tag2 = new LoadBundleTag();
        tag2.setBasename("org.seasar.teeda.core.taglib.core.TestMessages");
        tag2.setVar("messages");
        tag2.doStartTag();
        Map testMap2 = (Map)this.getFacesContext().getExternalContext().getRequestMap().get("messages");
        try {
            testMap.clear();
            LoadBundleTagTest.fail();
        }
        catch (UnsupportedOperationException e) {
            gotException = true;
        }
        LoadBundleTagTest.assertTrue((boolean)gotException);
        LoadBundleTagTest.assertTrue((boolean)testMap.containsKey(key));
        LoadBundleTagTest.assertTrue((boolean)testMap.containsValue(value));
        LoadBundleTagTest.assertTrue((boolean)((Object)testMap.entrySet()).equals(testMap2.entrySet()));
        LoadBundleTagTest.assertTrue((boolean)((Object)testMap).equals(testMap2));
        LoadBundleTagTest.assertEquals(testMap.get(key), (Object)value);
        LoadBundleTagTest.assertTrue((((Object)testMap).hashCode() == ((Object)testMap2).hashCode() ? 1 : 0) != 0);
        LoadBundleTagTest.assertFalse((boolean)testMap.isEmpty());
        LoadBundleTagTest.assertTrue((boolean)testMap.keySet().contains(key));
        try {
            testMap.put(key, value);
            LoadBundleTagTest.fail();
        }
        catch (UnsupportedOperationException e) {
            gotException = true;
        }
        LoadBundleTagTest.assertTrue((boolean)gotException);
        gotException = false;
        try {
            testMap.putAll(new HashMap());
            LoadBundleTagTest.fail();
        }
        catch (UnsupportedOperationException e) {
            gotException = true;
        }
        LoadBundleTagTest.assertTrue((boolean)gotException);
        gotException = false;
        try {
            testMap.remove(key);
            LoadBundleTagTest.fail();
        }
        catch (UnsupportedOperationException e) {
            gotException = true;
        }
        LoadBundleTagTest.assertTrue((boolean)gotException);
        LoadBundleTagTest.assertTrue((testMap.size() == 2 ? 1 : 0) != 0);
        LoadBundleTagTest.assertTrue((boolean)testMap.values().contains(value));
    }

    public void testRelease() throws Exception {
        LoadBundleTag tag = new LoadBundleTag();
        tag.setBasename("org.seasar.teeda.core.taglib.core.TestMessages");
        tag.setVar("messages");
        tag.release();
        LoadBundleTagTest.assertEquals(null, (String)tag.getBasename());
        LoadBundleTagTest.assertEquals(null, (String)tag.getVar());
    }
}

