/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.render.html.HtmlInputHiddenRenderer;

public class HtmlInputHiddenRendererTest
extends RendererTest {
    private HtmlInputHiddenRenderer renderer;
    private MockHtmlInputHidden htmlInputHidden;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlInputHiddenRenderer();
        this.htmlInputHidden = new MockHtmlInputHidden();
        this.htmlInputHidden.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_WithNoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((String)"<input type=\"hidden\" name=\"_id0\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlInputHidden.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlInputHidden.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((String)"<input type=\"hidden\" name=\"_id0\" value=\"abc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlInputHidden.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlInputHidden);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((String)"<input type=\"hidden\" id=\"a\" name=\"b:a\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        this.htmlInputHidden.setId("a");
        this.htmlInputHidden.getAttributes().put("unknown", "foo");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((String)"<input type=\"hidden\" id=\"a\" name=\"a\" value=\"\" unknown=\"foo\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlInputHidden.setId("A");
        this.htmlInputHidden.setValue("B");
        this.htmlInputHidden.getAttributes().put("type", "hidden");
        this.htmlInputHidden.getAttributes().put("name", "hoge");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputHidden);
        Diff diff = new Diff("<input type=\"hidden\" id=\"A\" name=\"A\" value=\"B\" />", this.getResponseText());
        HtmlInputHiddenRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_None() throws Exception {
        this.htmlInputHidden.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals(null, (Object)this.htmlInputHidden.getSubmittedValue());
    }

    public void testDecode_Success() throws Exception {
        this.htmlInputHidden.setClientId("key:aa");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key:aa", "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputHidden);
        HtmlInputHiddenRendererTest.assertEquals((Object)"12345", (Object)this.htmlInputHidden.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlInputHiddenRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlInputHiddenRenderer createHtmlInputHiddenRenderer() {
        return (HtmlInputHiddenRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlInputHiddenRenderer renderer = new HtmlInputHiddenRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlInputHidden
    extends HtmlInputHidden {
        private Renderer renderer_;
        private String clientId_;

        private MockHtmlInputHidden() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }

        public String getClientId(FacesContext context) {
            if (this.clientId_ != null) {
                return this.clientId_;
            }
            return super.getClientId(context);
        }

        public void setClientId(String clientId) {
            this.clientId_ = clientId;
        }
    }
}

