/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.mock.MockLifecycle;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class AbstractPhaseTest
extends TeedaTestCase {
    private PhaseListener[] listeners_;

    protected void setUp() throws Exception {
        this.listeners_ = this.getLifecycle().clearAllPhaseListener();
    }

    protected void tearDown() throws Exception {
        this.getLifecycle().setupDefaultPhaseListener(this.listeners_);
    }

    public void testPrePhase() throws Exception {
        ArrayList list = new ArrayList();
        MockNotifyBeforePhaseListener listener = new MockNotifyBeforePhaseListener(list);
        listener.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        this.getLifecycle().addPhaseListener((PhaseListener)listener);
        TargetPhase phase = new TargetPhase();
        phase.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        phase.prePhase((FacesContext)this.getFacesContext());
        AbstractPhaseTest.assertEquals((int)1, (int)list.size());
        PhaseEvent event = (PhaseEvent)list.get(0);
        AbstractPhaseTest.assertEquals((Object)PhaseId.APPLY_REQUEST_VALUES, (Object)event.getPhaseId());
        AbstractPhaseTest.assertEquals((Object)this.getLifecycle(), (Object)event.getSource());
    }

    public void testPostPhase() {
        MockAnyPhaseListener listener1 = new MockAnyPhaseListener();
        this.getLifecycle().addPhaseListener((PhaseListener)listener1);
        MockProcessValidationsPhaseListener listener2 = new MockProcessValidationsPhaseListener();
        this.getLifecycle().addPhaseListener((PhaseListener)listener2);
        LinkedList orderStack = new LinkedList();
        MockNotifiedPhase phase = new MockNotifiedPhase(orderStack);
        phase.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        phase.postPhase((FacesContext)this.getFacesContext());
        AbstractPhaseTest.assertEquals((int)2, (int)orderStack.size());
        PhaseListener l1 = (PhaseListener)orderStack.get(0);
        AbstractPhaseTest.assertEquals((Object)PhaseId.PROCESS_VALIDATIONS, (Object)l1.getPhaseId());
        ObjectAssert.assertSame((Object)listener2, (Object)l1);
        PhaseListener l2 = (PhaseListener)orderStack.get(1);
        AbstractPhaseTest.assertEquals((Object)PhaseId.ANY_PHASE, (Object)l2.getPhaseId());
        ObjectAssert.assertSame((Object)listener1, (Object)l2);
    }

    public void testIsTargetListener_succeed() {
        TargetPhase p = new TargetPhase();
        p.setPhaseId(PhaseId.ANY_PHASE);
        MockPhaseListener listener = new MockAnyPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.APPLY_REQUEST_VALUES));
        p.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        listener = new MockApplyRequestValuesPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.APPLY_REQUEST_VALUES));
        p.setPhaseId(PhaseId.INVOKE_APPLICATION);
        listener = new MockInvokeApplicationPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.INVOKE_APPLICATION));
        p.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        listener = new MockProcessValidationsPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.PROCESS_VALIDATIONS));
        p.setPhaseId(PhaseId.RENDER_RESPONSE);
        listener = new MockRenderResponsePhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.RENDER_RESPONSE));
        p.setPhaseId(PhaseId.RESTORE_VIEW);
        listener = new MockRestoreViewPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.RESTORE_VIEW));
        p.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        listener = new MockUpdateModelValuesPhaseListener();
        AbstractPhaseTest.assertTrue((boolean)p.isTargetListener(listener, PhaseId.UPDATE_MODEL_VALUES));
    }

    public void testIsTargetListener_fail() throws Exception {
        TargetPhase p = new TargetPhase();
        p.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        MockApplyRequestValuesPhaseListener listener = new MockApplyRequestValuesPhaseListener();
        AbstractPhaseTest.assertFalse((boolean)p.isTargetListener(listener, PhaseId.PROCESS_VALIDATIONS));
    }

    public void testGetLifecycle() {
        TargetPhase p = new TargetPhase();
        Lifecycle lifecycle = p.getLifecycle();
        AbstractPhaseTest.assertNotNull((Object)lifecycle);
        AbstractPhaseTest.assertTrue((boolean)(lifecycle instanceof MockLifecycle));
    }

    private static class MockNotifiedPhase
    extends TargetPhase {
        private LinkedList list_;

        public MockNotifiedPhase(LinkedList list) {
            this.list_ = list;
        }

        protected boolean isTargetListener(PhaseListener listener, PhaseId phaseId) {
            this.list_.add(listener);
            return super.isTargetListener(listener, phaseId);
        }
    }

    private static class MockNotifyBeforePhaseListener
    extends MockNotifyPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockNotifyBeforePhaseListener(List notify) {
            super(notify, 0);
        }
    }

    private static class MockNotifyPhaseListener
    implements PhaseListener {
        public static final int NOTIFY_BEFORE_PHASE = 0;
        public static final int NOTIFY_AFTER_PHASE = 1;
        public static final int NOTIFY_BOTH_PHASE = 2;
        private static final long serialVersionUID = 1L;
        private List notify_;
        private PhaseId phaseId_;
        private int whenNotify_ = -1;

        public MockNotifyPhaseListener(List notify) {
            this(notify, 2);
        }

        public MockNotifyPhaseListener(List notify, int whenNotify) {
            this.notify_ = notify;
            this.whenNotify_ = whenNotify;
        }

        public void afterPhase(PhaseEvent event) {
            if (this.whenNotify_ == 1 || this.whenNotify_ == 2) {
                this.notify_.add(event);
            }
        }

        public void beforePhase(PhaseEvent event) {
            if (this.whenNotify_ == 0 || this.whenNotify_ == 2) {
                this.notify_.add(event);
            }
        }

        public void setPhaseId(PhaseId phaseId) {
            this.phaseId_ = phaseId;
        }

        public PhaseId getPhaseId() {
            return this.phaseId_;
        }
    }

    private static class MockUpdateModelValuesPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockUpdateModelValuesPhaseListener() {
            super(PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    private static class MockRestoreViewPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockRestoreViewPhaseListener() {
            super(PhaseId.RESTORE_VIEW);
        }
    }

    private static class MockRenderResponsePhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockRenderResponsePhaseListener() {
            super(PhaseId.RENDER_RESPONSE);
        }
    }

    private static class MockProcessValidationsPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockProcessValidationsPhaseListener() {
            super(PhaseId.PROCESS_VALIDATIONS);
        }
    }

    private static class MockInvokeApplicationPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockInvokeApplicationPhaseListener() {
            super(PhaseId.INVOKE_APPLICATION);
        }
    }

    private static class MockApplyRequestValuesPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockApplyRequestValuesPhaseListener() {
            super(PhaseId.APPLY_REQUEST_VALUES);
        }
    }

    private static class MockAnyPhaseListener
    extends MockPhaseListener {
        private static final long serialVersionUID = 1L;

        public MockAnyPhaseListener() {
            super(PhaseId.ANY_PHASE);
        }
    }

    private static class MockPhaseListener
    implements PhaseListener {
        private static final long serialVersionUID = 1L;
        private PhaseId phaseId_;

        public MockPhaseListener(PhaseId phaseId) {
            this.phaseId_ = phaseId;
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
        }

        public PhaseId getPhaseId() {
            return this.phaseId_;
        }
    }

    private static class TargetPhase
    extends AbstractPhase {
        private PhaseId phaseId_ = PhaseId.ANY_PHASE;

        private TargetPhase() {
        }

        protected void executePhase(FacesContext context) {
        }

        protected PhaseId getCurrentPhaseId() {
            return this.phaseId_;
        }

        protected void setPhaseId(PhaseId phaseId) {
            this.phaseId_ = phaseId;
        }
    }
}

