/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl.commons;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.seasar.teeda.core.el.impl.commons.CoercionsUtil;

public class CoercionsUtilTest
extends TestCase {
    public void testCoerceToInteger() {
        CoercionsUtilTest.assertEquals((Object)new Integer(3), (Object)CoercionsUtil.coerceToInteger((Object)"3"));
        CoercionsUtilTest.assertEquals((Object)new Integer(1), (Object)CoercionsUtil.coerceToInteger((Object)new Boolean(true)));
        CoercionsUtilTest.assertEquals((Object)new Integer(0), (Object)CoercionsUtil.coerceToInteger((Object)new Boolean(false)));
        CoercionsUtilTest.assertEquals((Object)new Integer(1), (Object)CoercionsUtil.coerceToInteger((Object)new Double(1.1)));
        CoercionsUtilTest.assertNull((Object)CoercionsUtil.coerceToInteger(new ArrayList()));
    }

    public void testCoerceToPrimitiveBoolean() {
        CoercionsUtilTest.assertFalse((boolean)CoercionsUtil.coerceToPrimitiveBoolean(null));
        CoercionsUtilTest.assertFalse((boolean)CoercionsUtil.coerceToPrimitiveBoolean((Object)""));
        CoercionsUtilTest.assertFalse((boolean)CoercionsUtil.coerceToPrimitiveBoolean((Object)"false"));
        CoercionsUtilTest.assertFalse((boolean)CoercionsUtil.coerceToPrimitiveBoolean((Object)Boolean.FALSE));
        CoercionsUtilTest.assertTrue((boolean)CoercionsUtil.coerceToPrimitiveBoolean((Object)"true"));
        CoercionsUtilTest.assertTrue((boolean)CoercionsUtil.coerceToPrimitiveBoolean((Object)Boolean.TRUE));
    }

    public void testCoerce() {
        B b = new B();
        b.setStr("b");
        Object obj = CoercionsUtil.coerce((Object)b, (Class)A.class);
        CoercionsUtilTest.assertNotNull((Object)obj);
        CoercionsUtilTest.assertTrue((boolean)(obj instanceof B));
        CoercionsUtilTest.assertEquals((String)"b", (String)((A)obj).getString());
        CoercionsUtilTest.assertEquals((Object)"aaa", (Object)CoercionsUtil.coerce((Object)"aaa", (Class)String.class));
        CoercionsUtilTest.assertEquals((Object)new Integer(1), (Object)CoercionsUtil.coerce((Object)"1", (Class)Integer.class));
        CoercionsUtilTest.assertEquals((Object)new Character('a'), (Object)CoercionsUtil.coerce((Object)"a", (Class)Character.class));
        CoercionsUtilTest.assertNull((Object)CoercionsUtil.coerce(null, (Class)A.class));
    }

    public static class B
    extends A {
    }

    public static class A {
        private String str_;

        public void setStr(String str) {
            this.str_ = str;
        }

        public String getString() {
            return this.str_;
        }
    }
}

