/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.servlet;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.internal.EncodeUrlCustomizer;
import javax.faces.internal.WindowIdEncodeUrlCustomizer;
import javax.faces.internal.WindowIdUtil;
import javax.faces.mock.servlet.MockServletRequestImpl;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import junitx.framework.ArrayAssert;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.teeda.core.context.servlet.ServletExternalContextImpl;

public class ServletExternalContextImplTest
extends S2TestCase {
    public void testGetRequestServletPath() {
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)this.getServletContext(), "/hoge");
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)this.getResponse());
        ServletExternalContextImplTest.assertEquals((String)"/hoge", (String)context.getRequestServletPath());
        MockServletRequestImpl request2 = new MockServletRequestImpl((ServletContext)this.getServletContext(), "/hoge");
        ServletExternalContextImpl context2 = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request2, (ServletResponse)this.getResponse());
        ServletExternalContextImplTest.assertNull((Object)context2.getRequestServletPath());
    }

    public void testGetRequestPathInfo() {
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)this.getServletContext(), "/");
        request.setPathInfo("hoge");
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)this.getResponse());
        ServletExternalContextImplTest.assertEquals((String)"hoge", (String)context.getRequestPathInfo());
        MockServletRequestImpl request2 = new MockServletRequestImpl((ServletContext)this.getServletContext(), "/hoge");
        ServletExternalContextImpl context2 = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request2, (ServletResponse)this.getResponse());
        ServletExternalContextImplTest.assertNull((Object)context2.getRequestPathInfo());
    }

    public void testGetRequestMap() throws Exception {
        MockHttpServletRequest request = this.getRequest();
        request.setAttribute("a", (Object)"A");
        request.setAttribute("b", (Object)"B");
        ServletExternalContextImpl externalContext = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)this.getResponse());
        Map requestMap = externalContext.getRequestMap();
        ServletExternalContextImplTest.assertEquals((Object)"A", requestMap.get("a"));
        ServletExternalContextImplTest.assertEquals((Object)"B", requestMap.get("b"));
        this.assertEquals(null, requestMap.get("A"));
    }

    public void testGetRequestParameterMap() throws Exception {
        MockHttpServletRequest request = this.getRequest();
        request.setParameter("a", "A");
        request.setParameter("b", "B");
        ServletExternalContextImpl externalContext = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)this.getResponse());
        Map requestParameterMap = externalContext.getRequestParameterMap();
        ServletExternalContextImplTest.assertEquals((Object)"A", requestParameterMap.get("a"));
        ServletExternalContextImplTest.assertEquals((Object)"B", requestParameterMap.get("b"));
        this.assertEquals(null, requestParameterMap.get("A"));
    }

    public void testGetRequestParameterValuesMap() throws Exception {
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("a", "A1");
        request.addParameter("b", "B1");
        request.addParameter("a", "A2");
        request.addParameter("a", "A3");
        ServletExternalContextImpl externalContext = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)this.getResponse());
        Map requestParameterValuesMap = externalContext.getRequestParameterValuesMap();
        Object[] a = (String[])requestParameterValuesMap.get("a");
        ServletExternalContextImplTest.assertEquals((int)3, (int)a.length);
        ArrayAssert.assertEquivalenceArrays((Object[])new String[]{"A1", "A2", "A3"}, (Object[])a);
        String[] b = (String[])requestParameterValuesMap.get("b");
        ServletExternalContextImplTest.assertEquals((int)1, (int)b.length);
        ServletExternalContextImplTest.assertEquals((String)"B1", (String)b[0]);
        String[] c = (String[])requestParameterValuesMap.get("c");
        this.assertEquals(null, c);
    }

    public void testEncodeResourceURL() {
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        context.setEncodeUrlCustomizer((EncodeUrlCustomizer)new WindowIdEncodeUrlCustomizer());
        ServletExternalContextImplTest.assertEquals((String)"hoge", (String)context.encodeResourceURL("hoge"));
        WindowIdUtil.setWindowId((ExternalContext)context, (String)"1");
        ServletExternalContextImplTest.assertEquals((String)"hoge?wid=1", (String)context.encodeResourceURL("hoge"));
        ServletExternalContextImplTest.assertEquals((String)"hoge?aaa=bbb&wid=1", (String)context.encodeResourceURL("hoge?aaa=bbb"));
    }

    public void testEncodeResourceURL_WithoutCookie() {
        this.setResponse((MockHttpServletResponse)new MockHttpServletResponseImpl((HttpServletRequest)this.getRequest()){

            public String encodeURL(String url) {
                return url + ";jsessionid=HOGEHOGE";
            }
        });
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        context.setEncodeUrlCustomizer((EncodeUrlCustomizer)new WindowIdEncodeUrlCustomizer());
        ServletExternalContextImplTest.assertEquals((String)"hoge;jsessionid=HOGEHOGE", (String)context.encodeResourceURL("hoge"));
        WindowIdUtil.setWindowId((ExternalContext)context, (String)"1");
        ServletExternalContextImplTest.assertEquals((String)"hoge?wid=1;jsessionid=HOGEHOGE", (String)context.encodeResourceURL("hoge"));
        ServletExternalContextImplTest.assertEquals((String)"hoge?aaa=bbb&wid=1;jsessionid=HOGEHOGE", (String)context.encodeResourceURL("hoge?aaa=bbb"));
    }

    public void testEncodeActionURL() {
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        context.setEncodeUrlCustomizer((EncodeUrlCustomizer)new WindowIdEncodeUrlCustomizer());
        ServletExternalContextImplTest.assertEquals((String)"hoge", (String)context.encodeActionURL("hoge"));
        WindowIdUtil.setWindowId((ExternalContext)context, (String)"1");
        ServletExternalContextImplTest.assertEquals((String)"hoge?wid=1", (String)context.encodeActionURL("hoge"));
        ServletExternalContextImplTest.assertEquals((String)"hoge?aaa=bbb&wid=1", (String)context.encodeActionURL("hoge?aaa=bbb"));
    }

    public void testEncodeActionURL_WithoutCookie() {
        this.setResponse((MockHttpServletResponse)new MockHttpServletResponseImpl((HttpServletRequest)this.getRequest()){

            public String encodeURL(String url) {
                return url + ";jsessionid=HOGEHOGE";
            }
        });
        ServletExternalContextImpl context = new ServletExternalContextImpl((ServletContext)this.getServletContext(), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        context.setEncodeUrlCustomizer((EncodeUrlCustomizer)new WindowIdEncodeUrlCustomizer());
        ServletExternalContextImplTest.assertEquals((String)"hoge;jsessionid=HOGEHOGE", (String)context.encodeActionURL("hoge"));
        WindowIdUtil.setWindowId((ExternalContext)context, (String)"1");
        ServletExternalContextImplTest.assertEquals((String)"hoge?wid=1;jsessionid=HOGEHOGE", (String)context.encodeActionURL("hoge"));
        ServletExternalContextImplTest.assertEquals((String)"hoge?aaa=bbb&wid=1;jsessionid=HOGEHOGE", (String)context.encodeActionURL("hoge?aaa=bbb"));
    }
}

