/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import javax.faces.application.Application;
import javax.faces.el.VariableResolver;
import org.seasar.teeda.core.config.faces.assembler.impl.VariableResolverAssembler;
import org.seasar.teeda.core.mock.MockSingleConstructorVariableResolver;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class VariableResolverAssemblerTest
extends TeedaTestCase {
    public VariableResolverAssemblerTest(String name) {
        super(name);
    }

    public void testSimpleAssembleVariableResolver() throws Exception {
        String resolverName = "org.seasar.teeda.core.mock.MockVariableResolver";
        VariableResolverAssembler assembler = new VariableResolverAssembler(resolverName, (Application)this.getApplication());
        assembler.assemble();
        VariableResolver resolver = this.getApplication().getVariableResolver();
        VariableResolverAssemblerTest.assertNotNull((Object)resolver);
        VariableResolverAssemblerTest.assertTrue((boolean)(resolver instanceof MockVariableResolver));
    }

    public void testMarshalAssembleVariableResolver() throws Exception {
        this.getApplication().setVariableResolver((VariableResolver)new MockVariableResolver());
        String resolverName = "org.seasar.teeda.core.mock.MockSingleConstructorVariableResolver";
        VariableResolverAssembler assembler = new VariableResolverAssembler(resolverName, (Application)this.getApplication());
        assembler.assemble();
        VariableResolver resolver = this.getApplication().getVariableResolver();
        VariableResolverAssemblerTest.assertNotNull((Object)resolver);
        VariableResolverAssemblerTest.assertTrue((boolean)(resolver instanceof MockSingleConstructorVariableResolver));
        MockSingleConstructorVariableResolver r = (MockSingleConstructorVariableResolver)resolver;
        VariableResolverAssemblerTest.assertTrue((boolean)(r.getOriginal() instanceof MockVariableResolver));
    }
}

