/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.validator.AbstractValidatorTest;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;

public class LongRangeValidatorTest
extends AbstractValidatorTest {
    public void testConstants() throws Exception {
        LongRangeValidatorTest.assertEquals((String)"javax.faces.validator.LongRangeValidator.MAXIMUM", (String)"javax.faces.validator.LongRangeValidator.MAXIMUM");
        LongRangeValidatorTest.assertEquals((String)"javax.faces.validator.LongRangeValidator.MINIMUM", (String)"javax.faces.validator.LongRangeValidator.MINIMUM");
        LongRangeValidatorTest.assertEquals((String)"javax.faces.validator.LongRangeValidator.TYPE", (String)"javax.faces.validator.LongRangeValidator.TYPE");
        LongRangeValidatorTest.assertEquals((String)"javax.faces.LongRange", (String)"javax.faces.LongRange");
    }

    public void testInstanciation_withMax() throws Exception {
        long l = 123456L;
        LongRangeValidator validator = new LongRangeValidator(l);
        LongRangeValidatorTest.assertTrue((123456.0 == (double)validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testInstanciation_withMaxAndMin() throws Exception {
        long max = 2000L;
        long min = 3L;
        LongRangeValidator validator = new LongRangeValidator(max, min);
        LongRangeValidatorTest.assertTrue((2000L == validator.getMaximum() ? 1 : 0) != 0);
        LongRangeValidatorTest.assertTrue((3L == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testGetMaximum_setMax() throws Exception {
        LongRangeValidator validator = new LongRangeValidator(12345678L);
        LongRangeValidatorTest.assertTrue((12345678L == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testGetMaximum_notSetMax() throws Exception {
        LongRangeValidator validator = new LongRangeValidator();
        LongRangeValidatorTest.assertTrue((Long.MAX_VALUE == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testGetMinimum_setMin() throws Exception {
        LongRangeValidator validator = new LongRangeValidator(8L, 7L);
        LongRangeValidatorTest.assertTrue((7L == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testGetMinimum_notSetMin() throws Exception {
        LongRangeValidator validator = new LongRangeValidator();
        LongRangeValidatorTest.assertTrue((Long.MIN_VALUE == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testValidate_lessThanMinWhenBothMaxMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        LongRangeValidator validator = new LongRangeValidator(2L, 1L);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(0));
            LongRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LongRangeValidatorTest.assertEquals((String)"not in range(1,2,a)", (String)expected.getMessage());
            LongRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenBothMaxMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("b", Locale.ENGLISH);
        LongRangeValidator validator = new LongRangeValidator(2L, 1L);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(3));
            LongRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LongRangeValidatorTest.assertEquals((String)"not in range(1,2,b)", (String)expected.getMessage());
            LongRangeValidatorTest.success();
        }
    }

    public void testValidate_lessThanMinWhenMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        LongRangeValidator validator = new LongRangeValidator();
        validator.setMinimum(1L);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(0));
            LongRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LongRangeValidatorTest.assertEquals((String)"less than min(1,a)", (String)expected.getMessage());
            LongRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenMaxNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        LongRangeValidator validator = new LongRangeValidator(10L);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Float(11.0f));
            LongRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LongRangeValidatorTest.assertEquals((String)"more than max(10,a)", (String)expected.getMessage());
            LongRangeValidatorTest.success();
        }
    }

    public void testValidate_valueIsNotNumber() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("hoge", Locale.ENGLISH);
        LongRangeValidator validator = new LongRangeValidator(10L);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)"aaa");
            LongRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LongRangeValidatorTest.assertEquals((String)"type(hoge) is not double", (String)expected.getMessage());
            LongRangeValidatorTest.success();
        }
    }

    public void testValidate_NoValidate() throws Exception {
        MockFacesContext context = this.getFacesContext();
        LongRangeValidator validator = new LongRangeValidator(5L, 2L);
        validator.validate((FacesContext)context, (UIComponent)new MockUIComponent(), (Object)"");
    }

    public void testEquals1() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator(2L, 1L);
        LongRangeValidator v2 = new LongRangeValidator(2L, 1L);
        LongRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals2() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator(1L);
        LongRangeValidator v2 = new LongRangeValidator(1L);
        LongRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals3() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        LongRangeValidator v2 = new LongRangeValidator();
        LongRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals4() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        v1.setMinimum(3L);
        LongRangeValidator v2 = new LongRangeValidator();
        v2.setMinimum(3L);
        LongRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals5() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator(4L);
        LongRangeValidator v2 = new LongRangeValidator();
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals6() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        LongRangeValidator v2 = new LongRangeValidator(6L);
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals7() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator(7L);
        LongRangeValidator v2 = new LongRangeValidator(8L);
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals8() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        v1.setMinimum(3L);
        LongRangeValidator v2 = new LongRangeValidator();
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals9() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        LongRangeValidator v2 = new LongRangeValidator();
        v2.setMinimum(9L);
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals10() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator(2L);
        v1.setMinimum(8L);
        LongRangeValidator v2 = new LongRangeValidator(2L);
        v2.setMinimum(9L);
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals12() throws Exception {
        LongRangeValidator v1 = new LongRangeValidator();
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        LongRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    protected FacesContext getFacesContextWithSetMessageBundle(String viewRootId, Locale locale) {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setId(viewRootId);
        root.setLocale(locale);
        context.setViewRoot(root);
        return context;
    }

    protected Validator createValidator() {
        return new LongRangeValidator();
    }
}

