/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Arrays;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInputTest;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockValueBinding;

public class UISelectManyTest
extends UIInputTest {
    public void testGetSelectedValues() throws Exception {
        UISelectMany selectMany = this.createUISelectMany();
        selectMany.setValue((Object)new Object[]{"a", "b", "c"});
        Object[] actual = selectMany.getSelectedValues();
        UISelectManyTest.assertEquals((int)3, (int)actual.length);
        UISelectManyTest.assertEquals((Object)"a", (Object)actual[0]);
        UISelectManyTest.assertEquals((Object)"b", (Object)actual[1]);
        UISelectManyTest.assertEquals((Object)"c", (Object)actual[2]);
        UISelectManyTest.assertEquals((String)"typesafe alias for getValue", (Object)selectMany.getValue(), (Object)selectMany.getSelectedValues());
    }

    public void testSetSelectedValues() throws Exception {
        UISelectMany selectMany = this.createUISelectMany();
        selectMany.setSelectedValues(new Object[]{"A", "B"});
        Object[] actual = (Object[])selectMany.getValue();
        UISelectManyTest.assertEquals((int)2, (int)actual.length);
        UISelectManyTest.assertEquals((Object)"A", (Object)actual[0]);
        UISelectManyTest.assertEquals((Object)"B", (Object)actual[1]);
        UISelectManyTest.assertEquals((String)"typesafe alias for setValue", (Object)selectMany.getValue(), (Object)selectMany.getSelectedValues());
    }

    public void testSetSelectedValuesToValue_ValueBinding() throws Exception {
        UISelectMany component = this.createUISelectMany();
        MockValueBinding vb = new MockValueBinding();
        Object[] value = new Object[]{};
        MockFacesContext context = this.getFacesContext();
        vb.setValue((FacesContext)context, (Object)value);
        component.setValueBinding("selectedValues", (ValueBinding)vb);
        UISelectManyTest.assertEquals((Object)value, (Object)component.getSelectedValues());
        UISelectManyTest.assertEquals((Object)value, (Object)component.getValue());
        UISelectManyTest.assertEquals((Object)value, (Object)component.getValueBinding("selectedValues").getValue((FacesContext)context));
        UISelectManyTest.assertEquals((Object)value, (Object)component.getValueBinding("value").getValue((FacesContext)context));
    }

    public void testGetSelectedValuesToValue_ValueBinding() throws Exception {
        UISelectMany component = this.createUISelectMany();
        Object[] value = new Object[]{};
        MockFacesContext context = this.getFacesContext();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)context, (Object)value);
        component.setValueBinding("value", (ValueBinding)vb);
        vb = component.getValueBinding("selectedValues");
        UISelectManyTest.assertEquals((Object)value, (Object)vb.getValue((FacesContext)context));
        UISelectManyTest.assertEquals((Object)value, (Object)component.getSelectedValues());
        UISelectManyTest.assertEquals((Object)value, (Object)component.getValue());
    }

    public void testCompareValues_UISelectMany() throws Exception {
        UISelectMany selectMany = this.createUISelectMany();
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new String[]{"1", "2"}, (Object)new String[]{"2", "1"}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new String[]{"1", "2", "34"}, (Object)new String[]{"2", "34", "1"}));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{"1", "2", "34"}, (Object)new String[]{"2", "34"}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues(Arrays.asList("1", "2"), Arrays.asList("1", "2")));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues(Arrays.asList("1", "2"), Arrays.asList("2", "1")));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues(Arrays.asList("1", "2", "4"), Arrays.asList("1", "2", "3")));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues(Arrays.asList("1", "2"), (Object)new String[]{"1", "2"}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new int[]{1, 2}, (Object)new int[]{2, 1}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new int[]{1, 2, 34}, (Object)new int[]{2, 34, 1}));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new int[]{1, 2, 34}, (Object)new int[]{2, 34}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new String[0], (Object)new String[0]));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new String[]{"1"}, (Object)new String[]{"1"}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new String[]{null}, (Object)new String[]{null}));
        UISelectManyTest.assertEquals((boolean)false, (boolean)selectMany.compareValues((Object)new int[]{1, 2}, (Object)new Integer[]{new Integer(2), new Integer(1)}));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new int[]{1}, (Object)new String[]{"1"}));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{"1"}, (Object)"1"));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{"1"}, (Object)"2"));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{"2"}, (Object)"1"));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{""}, (Object)new String[]{null}));
        UISelectManyTest.assertEquals((boolean)true, (boolean)selectMany.compareValues((Object)new String[]{null}, (Object)new String[]{""}));
    }

    public void testValidateValue_Available() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        SingletonS2ContainerFactory.setContainer((S2Container)container);
        SingletonS2ContainerFactory.init();
        UISelectMany component = this.arrangeForValidateTest();
        MockFacesContext context = this.getFacesContext();
        component.validateValue((FacesContext)context, (Object)new String[]{"aV"});
        UISelectManyTest.assertEquals((boolean)true, (boolean)component.isValid());
        Iterator messages = context.getMessages();
        UISelectManyTest.assertEquals((boolean)false, (boolean)messages.hasNext());
    }

    public void testValidateValue_NotAvailable() throws Exception {
        UISelectMany component = this.arrangeForValidateTest();
        MockFacesContext context = this.getFacesContext();
        component.validateValue((FacesContext)context, (Object)new String[]{"aV", "c"});
        UISelectManyTest.assertEquals((boolean)false, (boolean)component.isValid());
        Iterator messages = context.getMessages();
        UISelectManyTest.assertEquals((boolean)true, (boolean)messages.hasNext());
        messages.next();
        UISelectManyTest.assertEquals((boolean)false, (boolean)messages.hasNext());
    }

    private UISelectMany arrangeForValidateTest() {
        UISelectMany component = this.createUISelectMany();
        component.setRendererType(null);
        component.setValid(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"aV");
        selectItem.setItemLabel("aL");
        component.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"bV");
        selectItem.setItemLabel("bL");
        component.getChildren().add(selectItem);
        return component;
    }

    private UISelectMany createUISelectMany() {
        return (UISelectMany)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UISelectMany();
    }
}

