/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTest;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBase;

public class UIFormTest
extends UIComponentBaseTest {
    public void testSetGetSubmitted() throws Exception {
        UIForm form = this.createUIForm();
        UIFormTest.assertEquals((String)"default is false", (boolean)false, (boolean)form.isSubmitted());
        form.setSubmitted(true);
        UIFormTest.assertEquals((boolean)true, (boolean)form.isSubmitted());
    }

    public void testProcessValidators_SubmittedTrue() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIForm form = this.createUIForm();
        form.setSubmitted(true);
        MockUIComponentBase child = new MockUIComponentBase(){

            public void processValidators(FacesContext context) {
                calls[0] = true;
            }
        };
        form.getChildren().add(child);
        MockFacesContext context = this.getFacesContext();
        form.processValidators((FacesContext)context);
        UIFormTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testProcessValidators_SubmittedFalse() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIForm form = this.createUIForm();
        form.setSubmitted(false);
        MockUIComponentBase child = new MockUIComponentBase(){

            public void processValidators(FacesContext context) {
                calls[0] = true;
            }
        };
        form.getChildren().add(child);
        MockFacesContext context = this.getFacesContext();
        form.processValidators((FacesContext)context);
        UIFormTest.assertEquals((boolean)false, (boolean)calls[0]);
    }

    public void testProcessUpdates_SubmittedTrue() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIForm form = this.createUIForm();
        form.setSubmitted(true);
        MockUIComponentBase child = new MockUIComponentBase(){

            public void processUpdates(FacesContext context) {
                calls[0] = true;
            }
        };
        form.getChildren().add(child);
        MockFacesContext context = this.getFacesContext();
        form.processUpdates((FacesContext)context);
        UIFormTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testProcessUpdates_SubmittedFalse() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIForm form = this.createUIForm();
        form.setSubmitted(false);
        MockUIComponentBase child = new MockUIComponentBase(){

            public void processUpdates(FacesContext context) {
                calls[0] = true;
            }
        };
        form.getChildren().add(child);
        MockFacesContext context = this.getFacesContext();
        form.processUpdates((FacesContext)context);
        UIFormTest.assertEquals((boolean)false, (boolean)calls[0]);
    }

    private UIForm createUIForm() {
        return (UIForm)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIForm();
    }
}

