/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.application.Application;
import javax.faces.component.AbstractUIComponentTeedaTest;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import junitx.framework.Assert;
import junitx.framework.ObjectAssert;
import junitx.framework.StringAssert;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.mock.NullApplication;
import org.seasar.teeda.core.mock.NullELParser;
import org.seasar.teeda.core.unit.TestUtil;

public class UIComponentBaseTeedaTest
extends AbstractUIComponentTeedaTest {
    public final void testGetClientId_NullId() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId(null);
        String clientId = component.getClientId((FacesContext)this.getFacesContext());
        UIComponentBaseTeedaTest.assertEquals((boolean)true, (boolean)StringUtil.isNotBlank((String)clientId));
        StringAssert.assertStartsWith((String)"_id", (String)clientId);
        UIComponentBaseTeedaTest.assertEquals(null, (String)component.getId());
    }

    public void testGetCliendId() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        UIComponentBaseTeedaTest.assertEquals((String)"foo", (String)component.getClientId((FacesContext)this.getFacesContext()));
    }

    public void testGetClientId_WithParentNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setClientId("b");
        parent.getChildren().add(component);
        String clientId = component.getClientId((FacesContext)this.getFacesContext());
        UIComponentBaseTeedaTest.assertNotNull((Object)clientId);
        UIComponentBaseTeedaTest.assertEquals((String)"b:a", (String)clientId);
    }

    public void testGetClientId_WithParentNotNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("a");
        MockUIComponentBase parent = new MockUIComponentBase();
        ObjectAssert.assertNotInstanceOf((Class)NamingContainer.class, (Object)((Object)parent));
        parent.setClientId("b");
        parent.getChildren().add(component);
        String clientId = component.getClientId((FacesContext)this.getFacesContext());
        UIComponentBaseTeedaTest.assertNotNull((Object)clientId);
        UIComponentBaseTeedaTest.assertEquals((String)"a", (String)clientId);
    }

    public void testGetClientId_ParentNamingContainerIdIsChanged() throws Exception {
        UIComponent parent = this.createUIComponent();
        MockFacesContext context = this.getFacesContext();
        MockUIComponentBase child = new MockUIComponentBase();
        parent.setId("a");
        parent.getChildren().add(child);
        String clientId1 = child.getClientId((FacesContext)context);
        UIComponentBaseTeedaTest.assertEquals((String)clientId1, (String)child.getClientId((FacesContext)context));
        parent.setId("b");
        if (parent instanceof NamingContainer) {
            Assert.assertNotEquals((Object)clientId1, (Object)child.getClientId((FacesContext)context));
        } else {
            System.out.println(parent.getClass().getName() + " is not NamingContainer");
            Assert.assertEquals((String)clientId1, (String)child.getClientId((FacesContext)context));
        }
    }

    public void testSaveAndRestoreState() throws Exception {
        UIComponentBase component1 = (UIComponentBase)this.createUIComponent();
        component1.setId("abc");
        component1.setRendered(true);
        component1.setRendererType("some renderer");
        component1.setTransient(true);
        component1.getAttributes().put("at", "vvv");
        component1.setValueBinding("vbb", (ValueBinding)new ValueBindingImpl((Application)new NullApplication(), "abc", (ELParser)new NullELParser()));
        MockFacesContext context = this.getFacesContext();
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setRenderKitId("HTML_BASIC");
        context.setViewRoot(viewRoot);
        Object state = component1.saveState((FacesContext)context);
        UIComponentBaseTeedaTest.assertTrue((boolean)(state instanceof Serializable));
        UIComponentBase component2 = this.createUIComponentBase();
        component2.restoreState((FacesContext)context, this.serializeAndDeserialize(state));
        UIComponentBaseTeedaTest.assertEquals((int)component1.getAttributes().size(), (int)component2.getAttributes().size());
        UIComponentBaseTeedaTest.assertEquals((int)component1.getChildCount(), (int)component2.getChildCount());
        UIComponentBaseTeedaTest.assertEquals((String)component1.getClientId((FacesContext)context), (String)component2.getClientId((FacesContext)context));
        UIComponentBaseTeedaTest.assertEquals((int)component1.getFacets().size(), (int)component2.getFacets().size());
        UIComponentBaseTeedaTest.assertEquals((String)component1.getId(), (String)component2.getId());
        UIComponentBaseTeedaTest.assertEquals((Object)component1.getParent(), (Object)component2.getParent());
        UIComponentBaseTeedaTest.assertEquals((String)component1.getRendererType(), (String)component2.getRendererType());
        UIComponentBaseTeedaTest.assertEquals((boolean)component1.getRendersChildren(), (boolean)component2.getRendersChildren());
        UIComponentBaseTeedaTest.assertEquals((String)component1.getValueBinding("vbb").getExpressionString(), (String)component2.getValueBinding("vbb").getExpressionString());
        UIComponentBaseTeedaTest.assertEquals((boolean)false, (boolean)component2.isTransient());
    }

    public void testSaveState_NotSaveChildren() throws Exception {
        UIComponentBase component1 = (UIComponentBase)this.createUIComponent();
        component1.getChildren().add(new UIParameter());
        component1.getFacets().put("a", new UIOutput());
        UIComponentBaseTeedaTest.assertEquals((int)1, (int)component1.getChildCount());
        UIComponentBaseTeedaTest.assertEquals((int)1, (int)component1.getFacets().size());
        MockFacesContext context = this.getFacesContext();
        Object state = component1.saveState((FacesContext)context);
        UIComponentBaseTeedaTest.assertTrue((boolean)(state instanceof Serializable));
        UIComponentBase component2 = this.createUIComponentBase();
        component2.restoreState((FacesContext)context, this.serializeAndDeserialize(state));
        UIComponentBaseTeedaTest.assertEquals((int)0, (int)component2.getChildCount());
        UIComponentBaseTeedaTest.assertEquals((int)0, (int)component2.getFacets().size());
    }

    private UIComponentBase createUIComponentBase() {
        return (UIComponentBase)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new MockUIComponentBase();
    }

    protected Object serializeAndDeserialize(Object input) throws IOException, ClassNotFoundException {
        return TestUtil.serializeAndDeserialize(input);
    }
}

