/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.teeda.ajax.AjaxUtil;

public class AjaxUtilTest
extends S2FrameworkTestCase {
    protected void tearDown() throws Exception {
        super.tearDown();
        AjaxUtil.clear();
    }

    public void testSetContentType() throws Exception {
        MockHttpServletResponse response = this.getResponse();
        AjaxUtil.setContentType((HttpServletResponse)response, null);
        AjaxUtilTest.assertEquals((String)"text/javascript; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"{\"value\":2,\"name\":\"a\"}");
        AjaxUtilTest.assertEquals((String)"text/javascript; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        AjaxUtilTest.assertEquals((String)"text/xml; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"<html><body></body></html>");
        AjaxUtilTest.assertEquals((String)"text/html; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"aaaaa");
        AjaxUtilTest.assertEquals((String)"text/plain; charset=UTF-8", (String)response.getContentType());
    }

    public void setUpSetContentTypeDicon() {
        this.include("contentTypeTest.dicon");
    }

    public void testSetContentTypeDicon() throws Exception {
        MockHttpServletResponse response = this.getResponse();
        AjaxUtil.setContentType((HttpServletResponse)response, null);
        AjaxUtilTest.assertEquals((String)"json/org; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"{\"value\":2,\"name\":\"a\"}");
        AjaxUtilTest.assertEquals((String)"json/org; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        AjaxUtilTest.assertEquals((String)"xml/org; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"<html><body></body></html>");
        AjaxUtilTest.assertEquals((String)"html/org; charset=UTF-8", (String)response.getContentType());
        response.setContentType(null);
        AjaxUtil.setContentType((HttpServletResponse)response, (String)"aaaaa");
        AjaxUtilTest.assertEquals((String)"text/org; charset=UTF-8", (String)response.getContentType());
    }
}

