/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.ResourceBundleMap;

public class LoadBundleTag
extends TagSupport {
    private static Logger logger = Logger.getLogger((Class)LoadBundleTag.class);
    private static final long serialVersionUID = 1L;
    private String basename;
    private String var;

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getBasename() {
        return this.basename;
    }

    public String getVar() {
        return this.var;
    }

    public int doStartTag() throws JspException {
        ResourceBundle bundle;
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        UIViewRoot viewRoot = context.getViewRoot();
        AssertionUtil.assertNotNull((String)"ViewRoot", (Object)viewRoot);
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = context.getApplication().getDefaultLocale();
        }
        String bname = null;
        String basename = this.getBasename();
        if (basename != null) {
            if (UIComponentTag.isValueReference(basename)) {
                ValueBinding vb = ValueBindingUtil.createValueBinding(context, basename);
                bname = (String)vb.getValue(context);
            } else {
                bname = basename;
            }
        }
        try {
            bundle = ResourceBundle.getBundle(bname, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException e) {
            logger.error((Object)("Resource bundle '" + bname + "' could not be found"));
            return 0;
        }
        context.getExternalContext().getRequestMap().put(this.var, new ResourceBundleMap(bundle));
        return 0;
    }

    public void release() {
        this.basename = null;
        this.var = null;
    }
}

