/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.Validator;
import javax.servlet.jsp.JspException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.taglib.core.MaxMinValidatorTag;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.core.util.ConverterUtil;

public class ValidateDoubleRangeTag
extends MaxMinValidatorTag {
    private static final long serialVersionUID = 1L;
    private static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    protected double minimum = 0.0;
    protected double maximum = 0.0;

    protected Validator createValidator() throws JspException {
        super.setValidatorId(VALIDATOR_ID);
        DoubleRangeValidator validator = null;
        validator = (DoubleRangeValidator)super.createValidator();
        AssertionUtil.assertNotNull((String)"DoubleRangeValidator", (Object)validator);
        this.evaluateExpressions();
        if (this.isMinimumSet()) {
            validator.setMinimum(this.minimum);
        }
        if (this.isMaximumSet()) {
            validator.setMaximum(this.maximum);
        }
        return validator;
    }

    private void evaluateExpressions() throws JspException {
        String max;
        FacesContext context = FacesContext.getCurrentInstance();
        String min = this.getMinimum();
        if (min != null) {
            if (BindingUtil.isValueReference(min)) {
                ValueBinding vb = ValueBindingUtil.createValueBinding(context, min);
                this.minimum = ConverterUtil.convertToDouble(vb.getValue(context));
            } else {
                this.minimum = ConverterUtil.convertToDouble(min);
            }
        }
        if ((max = this.getMaximum()) != null) {
            if (BindingUtil.isValueReference(max)) {
                ValueBinding vb = context.getApplication().createValueBinding(max);
                this.maximum = ConverterUtil.convertToDouble(vb.getValue(context));
            } else {
                this.maximum = ConverterUtil.convertToDouble(max);
            }
        }
    }
}

