/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ValueBindingFactory;
import org.seasar.teeda.core.el.impl.ELParserFactory;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;

public class ValueBindingFactoryImpl
implements ValueBindingFactory {
    private Map cache = Collections.synchronizedMap(new HashMap());
    private ELParser parser = ELParserFactory.createELParser();

    public void setELParser(ELParser parser) {
        this.parser = parser;
    }

    public ELParser getELParser() {
        return this.parser;
    }

    public ValueBinding createValueBinding(Application application, String expression) {
        if (StringUtil.isEmpty((String)expression)) {
            throw new EmptyRuntimeException("Expression string");
        }
        if (application == null) {
            throw new EmptyRuntimeException("Application");
        }
        ValueBinding vb = this.getValueBindingFromCache(application, expression);
        if (vb != null) {
            return vb;
        }
        vb = new ValueBindingImpl(application, expression, this.getELParser());
        this.cache.put(expression, vb);
        return vb;
    }

    public void clearCache() {
        this.cache.clear();
    }

    protected ValueBinding getRestoredValueBinding(StateHolder holder, String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        holder.restoreState(context, new Object[]{expression, this.getELParser()});
        return (ValueBinding)((Object)holder);
    }

    protected ValueBinding getValueBindingFromCache(Application application, String expression) {
        ValueBinding vb = (ValueBinding)this.cache.get(expression);
        if (vb != null && vb instanceof StateHolder) {
            vb = this.getRestoredValueBinding((StateHolder)((Object)vb), expression);
        }
        return vb;
    }
}

