/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.seasar.framework.util.AssertionUtil;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "_id";
    private String renderKitId = null;
    private String viewId = null;
    private List events = null;
    private int lastId = 0;
    private Locale locale = null;

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        if (this.renderKitId != null) {
            return this.renderKitId;
        }
        return (String)ComponentUtil_.getValueBindingValue(this, "renderKitId");
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public void queueEvent(FacesEvent event) {
        AssertionUtil.assertNotNull((String)"event", (Object)event);
        this.getEvents().add(event);
    }

    private List getEvents() {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        return this.events;
    }

    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        this.clearEventsIfResponseRendered(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.lastId = 0;
        this.clearEvents();
        super.encodeBegin(context);
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
        this.clearEventsIfResponseRendered(context);
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
        this.clearEventsIfResponseRendered(context);
    }

    public void processApplication(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
        this.clearEventsIfResponseRendered(context);
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Locale locale = null;
        FacesContext context = this.getFacesContext();
        if (this.getValueBinding("locale") != null) {
            Object obj = ComponentUtil_.getValueBindingValue(this, "locale");
            if (obj == null) {
                locale = ComponentUtil_.calculateLocale(context);
            } else if (obj instanceof Locale) {
                locale = (Locale)obj;
            } else if (obj instanceof String) {
                locale = this.getLocaleFromString((String)obj);
            }
        } else {
            locale = ComponentUtil_.calculateLocale(context);
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderKitId = (String)values[1];
        this.viewId = (String)values[2];
        this.locale = (Locale)values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.renderKitId, this.viewId, this.locale};
        return values;
    }

    private Locale getLocaleFromString(String localeStr) {
        Locale locale = Locale.getDefault();
        if (ComponentUtil_.isLocaleShort(localeStr)) {
            locale = new Locale(localeStr);
        } else if (ComponentUtil_.isLocaleLong(localeStr)) {
            String language = localeStr.substring(0, 2);
            String country = localeStr.substring(3, 5);
            locale = new Locale(language, country);
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastEvents(FacesContext context, PhaseId phaseId) {
        if (this.getEvents().isEmpty()) {
            return;
        }
        int phaseIdOrdinal = phaseId.getOrdinal();
        Iterator itr = this.events.iterator();
        while (itr.hasNext()) {
            FacesEvent event = (FacesEvent)itr.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != PhaseId.ANY_PHASE.getOrdinal() && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                try {
                    source.broadcast(event);
                }
                finally {
                    itr.remove();
                }
            }
            catch (AbortProcessingException e) {
                this.clearEvents();
                break;
            }
        }
    }

    protected void clearEventsIfResponseRendered(FacesContext context) {
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    private void clearEvents() {
        this.events = null;
    }

    public int getEventSize() {
        return this.getEvents().size();
    }
}

